#include "mbed.h"
 
Serial pc(USBTX, USBRX); // tx, rx
Serial mb(p9,p10);       //Serial Port on mbed
char receive[200]="";    //Receive char array
char pcRcv =0;      //Letter received from PC
char mbRcv =0;      //Letter received from the mbed port

 //Fortune string array    
char *fortuneString[10] =  {  
      "Today is your luck day. You will meet your lover.",
      "You are cursed today.  Stay home."
      //etc
     };

int main() {
    
    //Show prompt message to user    
    pc.printf("Please input your fortune number:");       
    
    while(1)     
    {           
        if(pc.readable() )  //If there is letter on PC port
        {
            pcRcv=pc.getc();  //Read a char from the PC 
            pc.printf("%c\n",pcRcv); //Bounce back user input to Tera Term
        
            if (pcRcv >= '0' && pcRcv <='9') //If you received a number, ignore any other letter
            {
                //Send the number to another side
                mb.putc(pcRcv); 
                
                //Read the fortune string endded with a new line "\n"
                mb.scanf("%[^\n]",receive);
                pc.printf("%s\n\n,receive);  //Show the string to the Tera Term
                
                pc.printf("Please input your fortune number:");
            }                
            
        }      
          
        if(mb.readable())  //If there is letter from another mbed
        {   
            mbRcv=mb.getc();  //Read a char from the mbed
            pc.printf("\nmbed received letter: %c\n",mbRcv); //Debug message. Show char received from another mbed to Tera Term
        
            if (mbRcv >= '0' && mbRcv <='9') //If you received a number
            {
                mb.printf("%s\n", fortuneString[mbRcv-0x30]);  //Send the fortune string to another mbed                
                pc.printf("Sent to another mbed %s\n", fortuneString[mbRcv-0x30]);  //Debug Message: Show what is sent to another mbed
            }    
            
            pc.printf("Please input your fortune number:");                 
        }     
               
    }
}