//*****************************************************************************
//* SERIAL PORT RECEIVE ATTACH DEMO PROGRAM
//* Simple demo program showing how the serial port "attach()" method is used
//* to interrupt when a character has been received into the USART. 
//*
//* The main() program sets up the serial port baudrate, attaches the
//* function pointer to the function to be called when a character is received
//* on this serial port, and then loops and flashed some LEDs.
//* 
//* Routine "void SerialRecvInterrupt(void)" is invoked anytime a character 
//* has been received by the by the USART. 
//*
//*****************************************************************************
#include "mbed.h"
#include <ctype.h>

#define BFR_SIZE         32         // Needs to be a power of two.
#define BFR_WRAP_MASK  0x1F         // Modulo 32

unsigned char rcvBuffer[BFR_SIZE];  // Receive buffer. 
unsigned char inIdx;                // Read by background, written by Int Handler.
unsigned char outIdx;               // Read by Int Handler, written by Background.

DigitalOut myled(LED1);
Serial pc (USBTX,USBRX);

//*****************************************************************************
// mc serial receive interrupt handler
//***************************************************************************** 

void SerialRecvInterrupt (void)
{
    unsigned char c;
     
    c = pc.getc();                // On receive interrupt, get the character.
    
    while (!pc.writeable()){};    // Wait until xmit buffer is empty.
    pc.putc(c);                   // Echo char back out the serial port.
     
    while (!pc.writeable()){};    // Make sure transmit buffer is empty.
    pc.putc(toupper(c));          // Echo the uppercase value of input char.
}

//*****************************************************************************
// Main Program
//*****************************************************************************

int main() {
    int i;
    
    for (i=0; i<BFR_SIZE; i++) {  // Clear buffer if you have OCD. 
        rcvBuffer[i] = 0; 
    }

    inIdx  = 0;                   // Initialize bfr input and output pointers. 
    outIdx = 0;  
    
    pc.baud(38400);                                // USART to PC USB USART.
    pc.attach (&SerialRecvInterrupt, pc.RxIrq);    // Recv interrupt handler
    pc.printf ("Serial interrupt demo\n");          

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
