//-----------------------------------------------------------------------------
// EXAMPLE: ANALOG READ AND STORE IN FILE
// Simple example program to read 100 analog samples at half second intervals.
// The program stores all 100 values and marks each sample as either
// "above" or "below" the chosen threshold of 0.6. The values are
// stored in text file analog.txt in the MBED folder. The samples are
// also written out to stdout (TeraTerm).
// LED 1 turns ON when the sample goes above 0.6, and OFF when it
// falls below 0.6. LED2 toggles ON/OFF to show program activity.
//
// D. Wendelboe  14 July 2010  - Submitted "as is". No guarantees implied.
//-----------------------------------------------------------------------------

#include "mbed.h"

#define ON   1
#define OFF  0

LocalFileSystem local("local");
AnalogIn myinput(p20);
DigitalOut myled(p5);
DigitalOut led1(LED1);
DigitalOut led2(LED2);

float analog_value;
int count = 0;

int main() {
    printf("Read and store 100 analog sample at 0.5 sec interval\r\n");
    
    FILE *fp = fopen("/local/analog.txt","w");  // Open a file to save samples
    printf("File analog.txt is open.\r\n");

    while (count < 100) {
        analog_value = myinput.read();  // Read analog (range 0.0 to 1.0)
        if (analog_value > 0.6)         // If value is above 0.6, then store
        {                               // it as an "above" value.
            fprintf (fp, "%3i: %f [above]\r\n", count+1, analog_value);
            led1 = ON;     // Turn LED ON if sample was stored.

        } else {           // Below 0.6, store it as a "below" value.
            fprintf (fp, "%3i: %f [below]\r\n", count+1, analog_value);
            led1 = OFF;    // Turn OFF if sample was not stored.
        }
        printf ("%3i: %f\r\n", count+1, analog_value);
        count++;           // Increment sample counter.
        led2 = ON;         // LED2 ON.
        wait_ms(250);      // Wait 0.25 second
        led2 = OFF;        // LED2 OFF.
        wait_ms(250);      // Wait 0.25 second
    }
    fclose(fp);            // Close the sampe file after 100 samples read.
    printf("File analog.txt closed.\r\n");
    printf("Finished. 100 samples taken. Bye!\r\n");
}
