#include <mbed.h>
#include "Roomba.h"

/**
 * データクラス
 * 基底のクラス定義のみ
 */
class Data {
    private:
    public:
        //virtual Data()
        //virtual ~Data() {}
};


/**
 * 送信データクラス
 * データクラスから派生
 */
class SendData : public Data{
    static const int LENGHT = 2;
    
    private:
        int wheelVelocity[LENGHT];
        
    public:
        SendData() {
        }
    
        SendData(int left, int right) {
            wheelVelocity[0] = left;
            wheelVelocity[1] = right;
        }

        int get(int index) {
            int result = -1;
            
            if (0 <= index && index < LENGHT) {
                result = wheelVelocity[index];
            }
            return result;
        }
};


/**
 * ルンバ制御クラスのインターフェース
 * 下記メソッドを継承先が実装すること
 */
class IRoomba {
    public:
        //virtual ~IRoomba(){};//なぜ宣言を書いたのか、コメントにした理由とともに忘れた
        //virtual void set(Data data) = 0;
        virtual bool send() = 0;
};


/*
 * ルンバ制御クラスの実装クラス
 */
class ImplRoomba : protected Roomba, protected IRoomba {
    static const int COUNT_TIME_OUT = 10;
    
    typedef Roomba base;
    
    private:
        int count;    //タイムアウト検出カウンタ（カウント値が一定数を超えればタイムアウト）
        bool isTimedOut;//タイムアウト検出フラグ
        DigitalOut _led;//notify()で使用するLED：ルンバ状態を通知する
        
        SendData *_data;//送信データ
    
    public:
        ImplRoomba(PinName tx, PinName rx, PinName led) : Roomba(tx, rx), _led(led), _data() {
            count = 0;
            isTimedOut = false;
            _led = 0;

            //beseの持つSerialインスタンスにコールバックメソッドを接続する
            base::_s.attach(this, &ImplRoomba::serialReceiveCallback, Serial::RxIrq);//!
        }
        
        
        /*
         * @bref データ設定メソッド
         */
        virtual void ImplRoomba::set(SendData data) {
           //Object of abstruct class type "ImplRoomba" is not allowed "ImplRoomba roomba(...);"
           _data = &data;
           
           base::_s.printf("%d", (*_data).get(1));
           
        }
        
        
        /*
         * @bref 送信メソッド
         */
        virtual bool ImplRoomba::send() {
            
            base::start();
            
            base::mode(Roomba::Mode::Full);
            
            int leftWheelVelocity = (*_data).get(0);
            int rightWheerVelocity = (*_data).get(1);
            base::drive(leftWheelVelocity, rightWheerVelocity);
            
            return true;
        }
        
        
        /*
         * @bref 通信状態通知メソッド
         */
        virtual void ImplRoomba::notify() {
            
            if (isTimedOut == true) {
                _led = 1;
            } else {
                _led = 0;
            }
        }
        
        
        /**
         * @bref 周期タイマのコールバックメソッド
         */
        virtual void ImplRoomba::periodicCallback() {

            count = count + 1;
    
            if (count > COUNT_TIME_OUT) {
                if (isTimedOut == false) {
                    isTimedOut = true;
                    ImplRoomba::notify();
                }
            }

            ImplRoomba::send();
        }

        /**
         * @bref シリアル受信時コールバックメソッド
         */
        virtual void ImplRoomba::serialReceiveCallback() {
            count = 0;
            
            _led = 1;
            base::_s.printf("hogehoge");

            if (isTimedOut) {
                isTimedOut = false;
                ImplRoomba::notify();
            }
        }
        
};


ImplRoomba roomba(SERIAL_TX, SERIAL_RX, LED1);
//Ticker ticker;
//Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut debugLed(LED1);

int main() {
    int leftWheelVelocity = 0;
    int rightWheelVelocity = 0;

    while (true) {        

        if (1) {
            //ルンバの走行値を更新
            leftWheelVelocity = -200;
            rightWheelVelocity = 500;
            
            SendData::SendData *data = new SendData(leftWheelVelocity, rightWheelVelocity);
            roomba.set(*data);
            delete data;
        }
        
        //ルンバへ定期的に走行値を送信
        roomba.periodicCallback();
        
        wait_ms(1000);
    }
}