#include "mbed.h"
//#include "Data.h"

#ifndef __ROOMBA_H_INCLUDED__
#define __ROOMBA_H_INCLUDED__


/**
 * ルンバ制御クラス
 */
class Roomba {
    public:
        struct Mode
        {
            enum EMode
            {
                Off,
                Passive,
                Safe,
                Full
            };
        };

        Roomba(PinName tx, PinName rx);
        
        bool mode(Roomba::Mode::EMode m);
        //Mode getMode();
        bool start();
        bool drive(int rightWheelVelocity, int leftWheelVelocity);
        bool battery(int* batteryCapacity);

    protected:
        Serial _s;
    
    private:
        Roomba::Mode::EMode _mode;
};

#endif