#include <mbed.h>
#include "Roomba.h"

/**
 * @bref コンストラクタ
 * @param tx
 * @param rx
 */
Roomba::Roomba(PinName tx, PinName rx):
    _s(tx, rx) {
    _mode = Roomba::Mode::Off;
}


/**
 * @bref start
 * @return  true
 */
bool Roomba::start() {
    
    _s.putc(128);
    
    return true;
}


/**
 * @bref 操作モード変更メソッド
 * @param 操作モード
 * @return true
 */
bool Roomba::mode(Roomba::Mode::EMode m) {

    _s.putc(132);//Full;
    
    return true;
}


/**
 * @bref 
 * @param true
 */
bool Roomba::drive(int rightWheelVelocity, int leftWheelVelocity) {
    
    bool ret = false;
    
    char command[10];
    
    if ((-500 <= rightWheelVelocity && rightWheelVelocity <= 500)
        && (-500 <= leftWheelVelocity && leftWheelVelocity <= 500)) {
        
        command[0] = 145;
        command[1] = (rightWheelVelocity & 0xFF00) >> 8;  //MSB
        command[2] = rightWheelVelocity & 0xFF;           //LSB
        command[3] = (leftWheelVelocity  & 0xFF00) >> 8;  //MSB
        command[4] = leftWheelVelocity  & 0xFF;             //LSB
        command[5] = '\0';
        
        for (int i = 0; i < 5; i++) {
            _s.putc(command[i]);
        }
        ret = true;
    }
    return ret;
}

/**
 * @bref バッテリ状態
 * 実装未完了
 * @param true
 * @return 
 * @retval 
 */
bool Roomba::battery(int* batteryCapacity) {
    bool ret = false;
    
    *batteryCapacity = 100;
    
    return ret;
}
