#ifndef __PWMSERVO_H__
#define __PWMSERVO_H__

#include <mbed.h>

/**
 * サーボ制御基底クラス
 * Kyoto-Densou-An 2014
 * @author yishii
 */

class PwmServo
{
    public:
        /**
         * コンストラクタ
         */
        PwmServo(PinName pin);
        
        /**
         * デストラクタ
         */
        ~PwmServo();
        
        /**
         * 角度設定
         * @param angle 角度
         */
        void setAngle(float angle);
    
    private:
        static const int PWM_CONTROL_PERIOD = 20; /**　@brief PWM周期 */
        PwmOut* pwm; /**　@brief PwmOutインスタンス */
};

#endif /* __PWMSERVO_H__ */

