#include <mbed.h>
#include <PwmServo.h>

/**
 * サーボ制御基底クラス
 */

/**
 * コンストラクタ
 */
PwmServo::PwmServo(PinName pin)
{
    pwm = new PwmOut(pin);
    pwm->period_ms(PWM_CONTROL_PERIOD);
    pwm->write(0.20);
}

/**
 * デストラクタ
 */
PwmServo::~PwmServo()
{
    delete pwm;
}

/**
 * 角度設定
 */
void PwmServo::setAngle(float angle)
{
    //pwm->pulsewidth(((angle/180) + 1) / 1000);
    pwm->pulsewidth_us((angle*2000)/180+500);//This values correspond to SG90.
}


