#ifndef __EXTENDEDSERVO_H__
#define __EXTENDEDSERVO_H__
 
#include "PwmServo.h"

/**
 * 拡張サーボクラス
 * サーボに任意の原点、方向、角度の上下限を設定するクラス
 * @author yosuke kirihata
 */
class ExtendedServo : public PwmServo
{
  public:
    /**
     * コンストラクタ
     */
    ExtendedServo(PinName pin);
    
    /**
     * コンストラクタ
     */
    ExtendedServo(PinName pin, int upperLimit , int lowerLimit);
    
    /**
     * コンストラクタ
     */
    ExtendedServo(PinName pin, int upperLimitAngle ,int lowerLimitAngle,
                  int offsetAngle, bool isReverse);
    /**
     * デストラクタ
     */
    ~ExtendedServo();
    
    //setter,getter
    void setOffsetAngle(int angle);
    int getOffsetAngle();
    void setDirection(bool isReverse);
    bool getDirection();
    void setUpperLimit(int angle);
    int getUpperLimit();
    void setLowerLimit(int angle);
    int getLowerLimit();
    
    /** 
     * 角度変換
     * @param angle 角度
     * @return
     */    
    int convertAngle(int angle);
    
    /** 
     * 角度反転
     * @param angle 角度
     * @param isReverse 方向フラグ
     * @return 
     */    
    int reverseAngle(int angle, bool isReverse);
    
    /** 
     * 角度設定
     * @param angle 目標角度
     * @return     
     */    
    int roundAngle(int angle, int upperLimit, int lowerLimit);
    
    /** 
     * 角度設定
     * @param angle 目標角度
     */    
    void setAngle(int angle);
    
    /** 
     * 原点回帰
     */        
    void backToStartPoint();
 
  private:
    int mOffsetAngle; /**　@brief 角度のオフセット値 */
    bool mIsReverse;  /**　@brief 方向フラグ */
    int mUpperLimit;  /**　@brief 角度上限値 */
    int mLowerLimit;  /**　@brief 角度下限値 */
};
 
#endif /* __EXTENDEDSERVO_H__ */