#include "mbed.h"
#include "Roomba.h"
#include "Data.h"

#ifndef __DERIVEDROOMBA_H_INCLUDED__
#define __DERIVEDROOMBA_H_INCLUDED__


/**
 * ルンバ制御クラスのインターフェース
 * 下記メソッドを継承先が実装すること
 */
class IRoomba {
    public:
        //virtual ~IRoomba(){};//なぜ宣言を書いたのか、コメントにした理由とともに忘れた
        //virtual void set(Data data) = 0;
        virtual bool send() = 0;
};


/*
 * ルンバ制御クラスの実装クラス
 */
class DerivedRoomba : protected Roomba, protected IRoomba {
    static const int COUNT_TIME_OUT = 10;
    
    typedef Roomba base;
    
    public:
        /*
         * @breaf コンストラクタ
         */
        DerivedRoomba::DerivedRoomba(PinName tx, PinName rx, PinName led);
                
        /*
         * @bref データ設定メソッド
         */
        virtual void DerivedRoomba::set(SendData* data);
        
        /*
         * @bref 送信メソッド
         */
        virtual bool DerivedRoomba::send();
        
        /*
         * @bref 通信状態通知メソッド
         */
        virtual void DerivedRoomba::notify();
        
        /**
         * @bref 周期タイマのコールバックメソッド
         */
        virtual void DerivedRoomba::periodicCallback();
        
        /**
         * @bref シリアル受信時コールバックメソッド
         */
        virtual void DerivedRoomba::serialReceiveCallback();
    
    private:
        int count;    //タイムアウト検出カウンタ（カウント値が一定数を超えればタイムアウト）
        bool isTimedOut;//タイムアウト検出フラグ
        DigitalOut _led;//notify()で使用するLED：ルンバ状態を通知する
        
        SendData *_data;//送信データ
    
};

#endif