#include <mbed.h>
#include "Roomba.h"
#include "DerivedRoomba.h"

DerivedRoomba::DerivedRoomba(PinName tx, PinName rx, PinName led) : Roomba(tx, rx), _led(led), _data() {
    count = 0;
    isTimedOut = false;
    _led = 0;

    //beseの持つSerialインスタンスにコールバックメソッドを接続する
    base::_s.attach(this, &DerivedRoomba::serialReceiveCallback, Serial::RxIrq);//!
}


/*
 * @bref データ設定メソッド
 */
void DerivedRoomba::set(SendData* data) {
    _data = data;
    
    //base::_s.printf("X[%p]", _data);
    //base::_s.printf("[%d, %d]", (*_data).wheelVelocity[0], (*_data).wheelVelocity[1]);
}


/*
 * @bref 送信メソッド
 */
bool DerivedRoomba::send() {
    
    int leftWheelVelocity = (*_data).get(0);
    int rightWheerVelocity = (*_data).get(1);
    
    //base::_s.printf("Y[%p]", _data);
    //base::_s.printf("[%d, %d]", (*_data).get(0), (*_data).get(1));
    //base::_s.printf("[%x, %x]", (*_data).wheelVelocity[0], (*_data).wheelVelocity[1]);
    
    base::start();
    base::mode(Roomba::Mode::Full);
    
    base::drive(leftWheelVelocity, rightWheerVelocity);
    
    return true;
}


/*
 * @bref 通信状態通知メソッド
 */
void DerivedRoomba::notify() {
            
    if (isTimedOut == true) {
        _led = 1;
    } else {
        _led = 0;
    }
}


/**
 * @bref 周期タイマのコールバックメソッド
 */
void DerivedRoomba::periodicCallback() {

    int leftWheelVelocity = (*_data).get(0);
    int rightWheerVelocity = (*_data).get(1);
    
    //base::_s.printf("Z[%p]", _data);
    //base::_s.printf("[%d, %d]", (*_data).get(0), (*_data).get(1));
    //base::_s.printf("[%x, %x]", (*_data).wheelVelocity[0], (*_data).wheelVelocity[1]);

    count = count + 1;
    
    if (count > COUNT_TIME_OUT) {
        if (isTimedOut == false) {
            isTimedOut = true;
            DerivedRoomba::notify();
        }
    }

    //_s.printf("a");
    DerivedRoomba::send();
    //_s.printf("b");
}

/**
 * @bref シリアル受信時コールバックメソッド
 */
void DerivedRoomba::serialReceiveCallback() {
    count = 0;
    _led = 1;
    //base::_s.printf("c");

    if (isTimedOut) {
        isTimedOut = false;
        DerivedRoomba::notify();
    }
}
        
