#ifndef __DELAYSERVO_H__
#define __DELAYSERVO_H__
 
#include "ExtendedServo.h"

/**
 * 遅延サーボクラス
 * @author yosuke kirihata
 */

#define DEFAULT_INTERVAL 100000 //100ms
#define DEFAULT_STEP_ANGLE 180
 
class DelayServo : public ExtendedServo
{
  public:
    /**
     * コンストラクタ
     */
    DelayServo(PinName pin);
    
    /**
     * コンストラクタ
     */
    DelayServo(PinName pin, int limitAngle);
    
    /**
     * コンストラクタ
     */
    DelayServo(PinName pin, int limitAngle, int interval);
    
    /**
     * コンストラクタ
     */
    //TODO:引数が多いのでBuilderパターンにする
    DelayServo(PinName pin, int limitAngle, int interval, int upperLimit ,int lowerLimit, int offsetAngle, bool isReverse);
    
    /**
     * デストラクタ
     */
    ~DelayServo();
    
    /** 
     * 更新周期再設定
     * @param interval 更新周期(us)
     */
    void updateInterval(int interval);
    
    /** 
     * 角度設定
     * @param angle 目標角度
     */    
    void setAngle(int angle);

  private:
    //Ticker mTick;     /**　@brief 周期タイマ */
    int mStepAngle;   /**　@brief 更新上限角度(刻み角度) */
    int mCurrentAngle;/**　@brief 現在角度 */
    int mTargetAngle; /**　@brief 目標角度 */
    int mInterval;    /**　@brief 更新間隔 */
    
    /** 
     * サーボ移動
     * @brief 周期タイマのコールバック関数
     */
  public:
    void moveServo();
};

#endif /* __DELAYSERVO_H__ */