/*

    Controller firmware for CaitSithDanger
    
    Kyoto-Densou-An 2014

    Author : yishii
*/
#include <mbed.h>
#include <PwmServo.h>

PwmServo::PwmServo(PinName pin)
{
    pwm = new PwmOut(pin);
    pwm->period_ms(PWM_CONTROL_PERIOD);
    pwm->write(0.20);
}

PwmServo::~PwmServo()
{
    delete pwm;
}

void PwmServo::setAngle(float angle)
{
    //pwm->pulsewidth(((angle/180) + 1) / 1000);
    pwm->pulsewidth_us((angle*2000)/180+500);//This values correspond to SG90.
}


