#include <mbed.h>
#include "DelayServo.h"
#include "def_resources.h"

/**
 * 遅延サーボクラス
 */

/**
 * コンストラクタ
 */
DelayServo::DelayServo(PinName pin) : ExtendedServo(pin)
//初期化リスト
,mStepAngle(DEFAULT_STEP_ANGLE)
,mCurrentAngle(0)
,mInterval(DEFAULT_INTERVAL)
{
  //mTick.attach_us(this, &DelayServo::moveServo, mInterval);
};

/**
 * コンストラクタ
 */
DelayServo::DelayServo(PinName pin, int stepAngle) : ExtendedServo(pin)
//初期化リスト
,mStepAngle(stepAngle)
,mCurrentAngle(0)
,mInterval(DEFAULT_INTERVAL)
{
  //mTick.attach_us(this, &DelayServo::moveServo, mInterval);
};

/**
 * コンストラクタ
 */
DelayServo::DelayServo(PinName pin, int stepAngle, int interval) : ExtendedServo(pin)
//初期化リスト
,mStepAngle(stepAngle)
,mCurrentAngle(0)
,mInterval(interval)
{
  //mTick.attach_us(this, &DelayServo::moveServo, mInterval);
};

/**
 * コンストラクタ
 */
DelayServo::DelayServo(PinName pin, int stepAngle, int interval,
  int upperLimit ,int lowerLimit, int offsetAngle, bool isReverse)
  : ExtendedServo(pin, upperLimit, lowerLimit, offsetAngle, isReverse)
//初期化リスト
,mStepAngle(stepAngle)
,mCurrentAngle(0)
,mInterval(interval)
{
  //mTick.attach_us(this, &DelayServo::moveServo, mInterval);
};

/**
 * デストラクタ
 */
DelayServo::~DelayServo() {
  //mTick.detach();
}

/**
 * サーボ移動
 */
void DelayServo::moveServo(void)
{
  //角度計算
  if (mTargetAngle - mCurrentAngle >= 0) {//順方向
    if (mTargetAngle - mCurrentAngle > mStepAngle) {//目標角度-現在角度が上限角度を超えるなら現在値を上限角度分移動
      mCurrentAngle = mCurrentAngle + mStepAngle;
    } else {
      mCurrentAngle = mTargetAngle;//上限角度以下なら現在角度は目標角度
    }
  } else {//逆方向
    if (mTargetAngle - mCurrentAngle < mStepAngle * -1) {
      mCurrentAngle = mCurrentAngle - mStepAngle;// + (mStepAngle * -1)
    } else {
      mCurrentAngle = mTargetAngle;
    }
  }
  
  ExtendedServo::setAngle(mCurrentAngle);
}

/**
 * 更新周期再設定
 */
void DelayServo::updateInterval(int interval)
{
  //mTick.detach();
  mInterval = interval;
  //mTick.attach_us(this, &DelayServo::moveServo, mInterval);
}

/**
 * 角度設定
 */
void DelayServo::setAngle(int angle)
{
  mTargetAngle = angle;
  moveServo();
}