#include "mbed.h"
#include "RPG.h"
#include "TextLCD.h"
#include "wave_player.h"
#include "MSCFileSystem.h"
#include <string.h>
#include <cstdio>

#define FSNAME "msc"
MSCFileSystem msc(FSNAME);

RPG rpg1(p21,p22,p23); //Set up RPG
TextLCD lcd1(p9, p10, p11, p12, p13, p14, TextLCD::LCD20x4); // rs, e, d4-d7
TextLCD lcd2(p5, p6, p7, p8, p19, p20, TextLCD::LCD20x4);
AnalogOut mySpeaker(p18);
DigitalIn pb_add(p29);
//SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
AnalogIn position(p17); //slider
wave_player waver(&mySpeaker);
Serial term(USBTX, USBRX); // tx, rx
int volume = 0;

int count = 0;
int dirt = 0;
char* songList[50];
char* playList[10]; 
int index = 0; 
int index_play = 0;
int len; 
int main()
{    

    DIR *d;
    struct dirent *p;
    d = opendir("/" FSNAME);
    
    if ( d != NULL )
    {
        while ( (p = readdir(d)) != NULL )
        {
            songList[index] = (char*)malloc(sizeof(char) * strlen(p->d_name));
            term.printf(" - %s\n", p->d_name);
            strcpy(songList[index++], p->d_name);
        }
        songList[index] = (char*)malloc(sizeof(char) * 8);
        strcpy(songList[index++], "Playlist");        
    }
    else
    {
        error("Could not open directory!");
    }      

    pb_add.mode(PullUp);
    FILE *wave_file;
          
    while(1)
    {
        char * selectedFile;
        volume = position*300;
        dirt = rpg1.dir(); //Get Dir
        count = count + dirt; //Ad Dir to count
        if(count > (index-1)){
            count = 0;
        }
        if(count < 0){
            count = index-1;
        }

        lcd1.cls();
        lcd1.printf("Song List: \n"); //Print out Count
        lcd1.printf("%s ", songList[count]);
        
        lcd2.cls();
        lcd2.printf("Volume: %d \n", volume); //Print out Count
        lcd2.printf("Mode: STOP");
        
        if(!pb_add)
        {
            playList[index_play] = (char*)malloc(sizeof(char) * strlen(songList[count]));
            strcpy(playList[index_play++], songList[count]);
            lcd2.cls();
            lcd2.printf("Song Added to PlayList"); //Print out Count
            wait(0.5);
        }
        if (rpg1.pb())
        {
           if(count == (index-1)&&index_play > 0)
           {
                for(int i = 0; i < (index_play);i++)
                {
                    len = 5+strlen(playList[i]);
                    selectedFile = (char*)malloc(sizeof(char) * len);
                    strcpy(selectedFile, "/msc/");
                    strcat(selectedFile, playList[i]);
                    wave_file=fopen(selectedFile,"r");
                    lcd2.cls();
                   lcd2.printf("Volume: %d \n", volume); //Print out Count
                   lcd2.printf("Mode: PLAY");
                   waver.play(wave_file);
                   fclose(wave_file);
                   free(selectedFile);
                   if(!pb_add) //stop the whole play list
                        break;
                }
           }
           else
           {
               len = 5+strlen(songList[count]);
               selectedFile = (char*)malloc(sizeof(char) * len);
               strcpy(selectedFile, "/msc/");
               strcat(selectedFile, songList[count]);
               wave_file=fopen(selectedFile,"r");
               lcd2.cls();
               lcd2.printf("Volume: %d \n", volume); //Print out Count
               lcd2.printf("Mode: PLAY");
               waver.play(wave_file);
               fclose(wave_file);
               free(selectedFile);
           }
           while(!pb_add){}; //prevent from adding stuff to the play list
        }
    }   
    
}