#include "mbed.h"
#include "Fuzzy.h"
 
Serial pc ( USBTX,USBRX );   /* Global Variable for debugging purposes PC */

void printMenu();
void setLimits( Fuzzy &Member ); 
void SimpleFuzzy( Fuzzy &Input, Fuzzy &Output );
void DoubleFuzzy( Fuzzy &MemberX, Fuzzy &MemberY, Fuzzy &Output );

int main() 
{
    char ch;
    Fuzzy Error;
    Fuzzy Dt;
    Fuzzy PWM;
    Error.printArt();
    printMenu();
    do
    {
      ch = pc.getc();
      pc.printf( "%c", ch );
      switch ( ch )
      {
        case '1':
          setLimits( Error );
          break;
        
        case '2':
          setLimits( Dt );
          break;
        
        case '3':
          setLimits( PWM );
          break;
        
        case '4':
          SimpleFuzzy( Error, PWM );
          break;
        
        case '5':
          DoubleFuzzy( Error, Dt, PWM );
          break;
        
        case '6':
          pc.printf( "\n--------end-----------------" );
          break;
      }
    }while( ch != '6' );
}


void setLimits( Fuzzy &Member )
{
  float low1, mid1, low2, mid2, hi;
  
  pc.printf( "\nlow1 = " );
  pc.scanf( "%f", &low1 );
  pc.printf( "%f",low1 );
  
  pc.printf( "\nmid1 = " );
  pc.scanf( "%f", &mid1 );
  pc.printf( "%f",mid1 );
  
  pc.printf( "\nlow2 = " );
  pc.scanf( "%f", &low2 );
  pc.printf( "%f",low2 );
  
  pc.printf( "\nmid2 = " );
  pc.scanf( "%f", &mid2 );
  pc.printf( "%f",mid2 );
  
  pc.printf( "\nhigh = " );
  pc.scanf( "%f", &hi);
  pc.printf( "%f",hi );
  
  Member.setMember( low1, mid1, low2, mid2, hi );
}


void SimpleFuzzy( Fuzzy &Input, Fuzzy &Output )
{
  float value_in, value_out, read_input1, read_input2;
  do
  {
    Input.limit = limit_low1;
    read_input1 = Input.read( Input.limit );
    
    Input.limit = limit_high;
    read_input2 = Input.read( Input.limit );
    
    pc.printf( "\n Give a value between %f and %f : ", read_input1, read_input2 );
    pc.scanf( "%f", &value_in );
    pc.printf("%f", value_in);
      
  }while ( !( value_in > read_input1    &&   value_in < read_input2 ) );  // Within Limits 
  
  value_out = Input.getValue( value_in, Output );
  pc.printf( "\nFor value %f, your output is %f.", value_in, value_out );
  
}

void DoubleFuzzy( Fuzzy &MemberX, Fuzzy &MemberY, Fuzzy &Output )
{
  float valueX, valueY, valueOut, read_input1, read_input2;
  
  do
  {
    MemberX.limit = limit_low1;
    read_input1 = MemberX.read( MemberX.limit );
    
    MemberX.limit = limit_high;
    read_input2 = MemberX.read( MemberX.limit );
    
    pc.printf( "\n Give a value between %f and %f : ", read_input1, read_input2 );
    pc.scanf( "%f", &valueX );
    pc.printf("%f", valueX);
       
  }while ( !( valueX > read_input2    &&   valueX < read_input2 ) );  // Within Limits 
    
  do
  {
    
    MemberY.limit = limit_low1;
    read_input1 = MemberY.read( MemberY.limit );
    
    MemberY.limit = limit_high;
    read_input2 = MemberY.read( MemberY.limit );
    
    pc.printf( "\n Give a value between %f and %f : ", read_input1, read_input2 );
    pc.scanf( "%f", &valueY );
    pc.printf("%f", valueY);
        
  }while ( !( valueY > read_input1    &&   valueY < read_input2 ) );  // Within Limits 
    
    valueOut = MemberX.getValue( valueX, valueY, MemberX, MemberY, Output );
    pc.printf( "\nFor value %f and %f, your output is %f.", valueX, valueY, valueOut );
  
}

void printMenu()
{
  pc.printf( "\n\n --== Fuzzy Logic ==--\n" );
  pc.printf( "\nSelect an option: " );
  pc.printf( "\n[1] Set Limits X" );
  pc.printf( "\n[2] Set Limits Y" );
  pc.printf( "\n[3] Set Limits Output" );
  pc.printf( "\n[4] One Argument Fuzzy" );
  pc.printf( "\n[5] Two Argument Fuzzy" );
  pc.printf( "\n[6] Exit\n" );  
}

