#include "mbed.h"

/* ===================-  STRUCTURES -=========================================== */

struct limitStr             /* Limits of each Fuzzy Member */
{
  float low_;    /* Lower limit of the Member                  /\                */
  float mid_;    /* Center of the Member                      /  \               */
  float high_;   /* Higher limit of the Member               /  | \              */ 
                /*                                     low /  mid \ high        */
 };             /*                                                              */
                /*                                                              */
struct areaStr
{
  float left_;     /* values of the areas of each member */
  float center_;
  float right_;
};

enum limitEnum   // public enum constructor
{
  limit_low1,
  limit_mid1,
  limit_low2,
  limit_mid2,
  limit_high
};
    
/* ===================- FUZZY CLASS -=========================================== */
class Fuzzy
{
  public:
    
    void  setMember( float low1, float mid1, float low2, float mid2, float hi );
    limitEnum limit;             // Enumerated names of the limits
    float read( limitEnum element );
    float getValue ( float x, Fuzzy Output );
    float getValue ( float x, float y, Fuzzy memberX, Fuzzy memberY, Fuzzy output );
    void  printArt();
  
  private:
    
    limitStr         left, center, right;    // Holds the values
    areaStr          Area;                     // 
    
    float fuzz( float value, limitStr member );
  /* ****************************************************************************** *
   * Fuzzifier (Fusificador):                                                       *
   * This Function calculates the degree of membership of the 'value' passed in the *
   * 'member' function it belongs to.                                               *
   *                                                                                *
   * 'value' = any float form 'low1' to 'hi' of that particular member              *
   * ****************************************************************************** */
    
    float min( float x1, float x2 );
    /* *************************************************************************** *
     * Calculates the minimum value of the two arguments                           *
     * *************************************************************************** */
         
    float max( float x1, float x2, float x3 );
    /* *************************************************************************** *
     * Calculates the maximum value of the three arguments                         *
     * *************************************************************************** */
    
    void calculateArea( float n, float z, float p , Fuzzy Output );
    /* *************************************************************************** *
     * Calculates the area of the given value to the Output Membership             *
     * 'n' Negative Function
     * 'z' Zero Function
     * 'p' Positive Function
     * *************************************************************************** */
    
     float defuzz( Fuzzy Output );
     /* *************************************************************************** *
      * This function calculates the final output to return, The object already     *
      * the values defined, it needs an Oputput membership to generate a return     *
      * value                                                                       * 
      * *************************************************************************** */
};