/*******************************************************************\
 *                                                                 *
 *                        DESLIZADOR LINEAL UTN                    *
 *                                                                 *
 *   Archivo:      main.cpp                                        *
 *   Autor:        Ernesto Palacios <meacatronica.mid@gmail.com>   *
 *   Version:      v2.3                                            *
 *   Dependencias: setup.h, setup.cpp                              *
 *   Descripcion:  Este es el archivo principal para el microcon-  *
 *                 trolador mbed para la comunicacion  y  control  *
 *                 del deslizador                                  *
 *   Fecha:        Ibarra, 05 de junio de 2012                     *
 *                                                                 *
 *******************************************************************/
 
#include "mbed.h"
#include "qeihw.h"
#include "setup.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
#include "RPCVariable.h"


//  Configuraci&#65533;n de Entradas / Salidas 

Serial          pc( USBTX, USBRX );   //Comunicacion Serial directa al computador
Serial          RS_232(p13, p14);    //Comunicacion Serial para MAX232

QEIHW           encoder(  QEI_DIRINV_CMPL,     // CW = postive;  CCW = negative
                 QEI_SIGNALMODE_QUAD, // Absolute encoder
                 QEI_CAPMODE_2X,      // PhA anb PhB
                 QEI_INVINX_NONE      // Not inverted index
                 );

Timer           crono;                 // Reloj Interno de mbed

DigitalOut      pin_son( p7 );       // SON
DigitalOut      pin_dir( p26 );     //  SIGN+
InterruptIn     pin_alm( p8 );     //   ALM 
AnalogOut       aout( p18 );      //    VOUT
//PIN_06        pto_generator    //     PULS+

DigitalIn       isHTTP( p15 );   // Modo Ethernet/Serial
DigitalIn       isFast( p16 );   // Serial Alta velocidad/Baja Velocidad
DigitalIn       isPC  ( p17 );   // Salida a compuador o MAX232

DigitalOut      led_verde( p21 ); // Led verde del conector Ethernet
DigitalOut      led_rojo(  p22 ); // Led naranja del conector Ethernet

// Alarmas en los optoacopladores
InterruptIn     limite_1( p23 );
InterruptIn     limite_2( p24 );
InterruptIn     limite_3( p25 );
InterruptIn     limite_4( p29 );


//  Objetos Ethernet

EthernetNetIf eth;  
HTTPServer svr;
LocalFileSystem fs("local");


//  Anadir funciones al Protocolo RPC:
//
//  estas son las funciones de acceso de la libreria HTTP_ASM sobre
//  el Protocolo RPC
RPCFunction SetFQ  (&setPTO_eth,  "PTO");
RPCFunction SetAOUT(&setAout_eth, "AOUT");
RPCFunction SetDIR (&setDir_eth,  "DIR");
RPCFunction SetSON (&setSON_eth,  "SON");
RPCFunction SetANG (&setANG_eth,  "ANG"); 
RPCFunction SetSpd (&setSPD_eth,  "VAN"); 
RPCFunction ReadEnc(&getENC_eth,  "ENC");
RPCFunction ClrEnc (&setENC_eth,  "CLR");
RPCFunction ReadRPM(&getRPM_eth,  "RPM");
RPCFunction GoHome(&setHOME_eth,  "INI");
RPCFunction GetAlm( &getALM_eth,  "ALM");


int main() {
    
    pin_alm.fall( &ISR_Alarm ); // Entrada de la alarma driver

     limite_1.rise( &ISR_Alm_encoder );  // Alarma de colisión 1
     limite_2.rise( &ISR_Adv_encoder );  // Alarma de colisión 1
     limite_3.rise( &ISR_Adv_motor );  // Alarma de colisión 1
     limite_4.rise( &ISR_Alm_motor );  // Alarma de colisión 1

    encoder.SetDigiFilter(480UL);         // number of clock cycles the signal must be at high to sense it
    encoder.SetMaxPosition(0xFFFFFFFF);   // max number before overflow - may be changed for 360 or a multiple
    encoder.SetVelocityTimerReload( 0xFFFFF );    


//***************    Configura Red Ethernet     **************************************************//
    if( isHTTP )   
    {

        // Anade clases base al protocolo RPC
        Base::add_rpc_class<AnalogIn>();
        Base::add_rpc_class<AnalogOut>();
        Base::add_rpc_class<DigitalIn>();
        Base::add_rpc_class<DigitalOut>();
        Base::add_rpc_class<DigitalInOut>();
        Base::add_rpc_class<PwmOut>();
        Base::add_rpc_class<Timer>();
        Base::add_rpc_class<BusOut>();
        Base::add_rpc_class<BusIn>();
        Base::add_rpc_class<BusInOut>();
        Base::add_rpc_class<Serial>();
        
        led_verde = 0;    //Esperando configuracion
        led_rojo  = 1;  
        
        // Configura conexion Ethernet
        printf("Configurando...\n");
        EthernetErr ethErr = eth.setup();
        if(ethErr)
        {
            printf("Error %d en la configuracion.\n", ethErr);
            led_rojo  = 0;  
            return -1;
        }
        printf("Configuracion correcta!\n");

        led_verde = 1;    //Configuracion correcta led verde encendido
        led_rojo  = 0;  
                                           
        FSHandler::mount("/local", "/files"); //Monta /local en /files que es el directorio web
        FSHandler::mount("/local", "/");      //Mount /local en / que es el directorio raiz
  
        //Handles para la comunicacion
        svr.addHandler<SimpleHandler>("/hello");
        svr.addHandler<RPCHandler>("/rpc");
        svr.addHandler<FSHandler>("/files");
        svr.addHandler<FSHandler>("/"); 
        
        svr.bind(80);   // Puerto de comunicacion.
                       
        printf("Listo para comunicacion...\n");
   
        // Para probar la correcta configuracion acceder a mbed.htm
        // http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
   
    }


//***************    Configura Comunicacion Serial     **************************************************//
    else  // Caso Contrario Anadir modo Serial
    {
        int fast_baud = getBaud();
        if( isPC )                      // Utiliza el Puerto Virtual Incluido.
        {
            pc.attach( &ISR_Serial );
            if( isFast )                     //Configurar Serial a alta velocidad
                pc.baud( fast_baud );
        }
        else                          // Utiiliza el puerto serial hacia MAX232
        {
            RS_232.attach( &ISR_Serial );
            if( isFast )                     //Configurar Serial a alta velocidad
                RS_232.baud( fast_baud );
        }
    }
    
//*******************************************************************************************************//
    
    
    //________ Ajustes iniciales del Driver _________//
    
    

    setTimer2();    // Configurar PTO
    pin_son = 0;   // Servo Apagado por defecto
    aout = 0.5;   // Voltaje de salida 0V por defecto( +-10V! )
    
    
    while(1) 
    {
        if( isHTTP )
        {
            Net::poll();  // Revisa la red solo si la coneccion es HTTP
            led_verde = led_verde ^ 1;    // Toggle Led Verde...  esperando transmicion
        }
    }
}
