/**
 * @file   setup.h
 * @author Ernesto Palacios
 * @brief  decalracion de funciones
 *
 * Created on 25 de Marzo de 2012
 *
 * Licencia  GPL v3.0
 * http://www.gnu.org/licenses/gpl-3.0.html
 */


#ifndef SETUP_H
#define SETUP_H

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
#include "RPCVariable.h"

/** @brief: Esta funcion configura al Timer2
 *  para que las salidas p5 y p6 del mbed
 *  se alternen cada vez que se iguala al
 *  registro MR2 y MR3.
 */
void setTimer2();


/** @brief: Esta es la rutina que cambia la frecuencia
 *  de salida del Micro en Serial
 */
void setPTO( int freq );


/** @brief: Esta es la rutina para obtener la onfiguracion
 *  de la velocidad serial para el puerto MAX_232
 */
int configurarBaudios();


/** @brief: Esta es la rutina que maneja las interrupciones
 *  seriales, al recibir un caracter.
 */
void ISR_Serial();


/** @brief: Esta es la rutina que maneja las interrupciones
 *  seriales, al recibir un caracter.
 */
void ISR_Alm_encoder();


/** @brief: Esta es la rutina que maneja las interrupciones
 *  seriales, al recibir un caracter.
 */
void ISR_Alm_motor();


/** @brief: Esta es la rutina que maneja las interrupciones
 *  seriales, al recibir un caracter.
 */
void ISR_Adv_encoder();


/** @brief: Esta es la rutina que maneja las interrupciones
 *  seriales, al recibir un caracter.
 */
void ISR_Adv_motor();


/** @brief: Esta es la rutina que maneja la interrupcion
 *  de alarma del servomotor
 */
void ISR_Alarm();



/** @brief: Esta Funcion calcula el valor necesario
 *  en el MatchRegister para obtener una frecuencia
 *  de salida.
 * @param fout Frecuencia de salida deseada
 * @return El valor que debe tener el MatchRegister 
 */
int getMRvalue( int fout  );



/** @brief: Esta es la rutina que maneja la interrupcion
 *  de alarma
 */
int getBaud();



/** @brief: Esta Funcion cambia el valor del Registro 2
 */
void setMR2( int newValue );


/** @brief: Esta Funcion arranca el timer
 */
void startTimer2();


/** @brief: Esta Funcion detiene el timer
 */
void stopTimer2();


//________________  FUNCIONES ETHERNET ___________________//


/** @brief: Esta es la rutina que cambia la frecuencia
 *  de salida del Micro en comunicacion Ethernet
 */
void setPTO_eth ( char * input, char * output );    


/** @brief: Esta Funcion cambia el voltaje de salida el 
 *  valor ingresado debe ser en porcentaje.
 *  Desde -100% hasta +100% dependiendo de la velocidad
 *  y el sentido de giro 
 */
void setAout_eth( char * input, char * output );     


/** @brief: Cambiar Direccion @ PTO
 */
void setDir_eth ( char * input, char * output );    


/** @brief: Encender el Servo (bloquearlo)
 */
void setSON_eth ( char * input, char * output );    


/** @brief: Cambiar el angulo actual del eje del motor
 */
void setANG_eth( char * input, char * output );


/** @brief: Cambiar la velocidad de giro al cambiar el angulo del motor
 */
void setSPD_eth( char * input, char * output );


/** @brief: Leer desde el encoder
 */
void getENC_eth( char * input, char * output );


/** @brief: Leer desde el encoder
 */
void setENC_eth( char * input, char * output );


/** @brief: Limpiar contador del encoder
 */
void getRPM_eth( char * input, char * output );


/** @brief: Lleva el carro hasta el inicio del recorrido y encera el encoder
 */
void setHOME_eth( char * input, char * output );


/** @brief: Comprueba el estado de las alarmas
 */
void getALM_eth ( char * input, char * output );

//________________ FUNCIONES ENCODER __________________//

/** @brief: Cambiar Direccion @ PTO
 */
int read_encoder();


/** @brief: Cambiar Direccion @ PTO
 */
void clear_encoder();



// Legacy
void setMR3( int newValue );   
void setPrescaler( int newValue );
EthernetNetIf configurarEthernet();


#endif