
#include "mbed.h"
#include "L293D.h"

// Constructor
 L293D::L293D( PwmOut pwmLeft, PwmOut pwmRight, DigitalOut left, DigitalOut right )
     :_left(left), _right(right),_pwmLeft( pwmLeft ), _pwmRight( pwmRight ){
    
        _pwmLeft  = 0.0;
        _pwmRight = 0.0;
        
        _left = 0;
        _right= 0;
                        
}

void L293D::setSpeedLeft( float speed )
{
    _speedLeft = speed;
    
    _left = ( speed > 0.0 );
    _pwmLeft = abs( speed );

}

void L293D::setSpeedRight( float speed )
{
    _speedRight = speed;
    _right    = ( speed > 0.0 );
    _pwmRight = abs( speed );

}


float L293D::getSpeedLeft()
{
    float temp = _pwmLeft.read();
        
    // This is done to ensure a -1.0 to 1.0 value is returned
    if( _speedLeft > 0 )
        return temp;
    else
        return temp * -1;
    
}

float L293D::getSpeedRight()
{
    float temp = _pwmRight.read();
    
    // This is done to ensure a -1.0 to 1.0 value is returned
    if( _speedRight > 0 )
        return temp;
    else
        return temp * -1;
    
}




    
