/*
    Copyright (c) 2019 Yifan DU
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
 
        1.1     19-Feb.-2019    Add return 'float' function
        1.0     2-Feb.-2019     Initial release.
        
    *****************************************************************
  Attention: This drive is working well with "LPD3806-600GM-G5-24G'
  *****************************************************************
  @code
  #include "mbed.h"
  #include "Rotary_Encoder.h"
    
  Rotary_Encoder Encoder(PA_0, PA_1);

  int main(void)
  {
      while(1)
    {
         printf("Direction: %s\r\n", Encoder.Calculate_Direction());
         printf("\r\n");

         wait(0.2);
    }
  }
  @endcode
 *****************************************************************
*/

#ifndef _ROTARY_ENCODER_H_
#define _ROTARY_ENCODER_H_

#include "mbed.h"

class Rotary_Encoder 
{
    private:
        char                    Direction[5];   
        int                     Encoder_Counter;
        float         Direction_Numb;
        InterruptIn     Green_Pin, White_Pin;
    
        void Green_Pin_Rise(void);
        // Change 'Encoder_Direction' when detecting voltage in 'Green Pin' from LOW to HIGH.
    
        void White_Pin_Rise(void);
        // Change 'Encoder_Direction' when detecting voltage in 'White Pin' from LOW to HIGH.
    
    public:
        Rotary_Encoder(PinName White, PinName Green);
        // @Param  White  The pin whitch is connected to the encoder white line.
        // @Param  Green    The pin whitch is connected to the encoder green line.
    
        char *Show_Direction_In_char(void);
        // Return Direciton.
    
        float Calculate_Direction(void);
};

#endif
