#include "Rotary_Encoder.h"

Rotary_Encoder::Rotary_Encoder(PinName White, PinName Green) : Green_Pin(Green), White_Pin(White)
{
    Green_Pin.rise(this, &Rotary_Encoder::Green_Pin_Rise);
    White_Pin.rise(this, &Rotary_Encoder::White_Pin_Rise);
}

void Rotary_Encoder::Green_Pin_Rise(void)
{
    if(White_Pin.read() == 0)
        Encoder_Counter++;
    else
        Encoder_Counter--;
}
    
void Rotary_Encoder::White_Pin_Rise(void)
{
    if(Green_Pin.read() == 0)
        Encoder_Counter--;
    else
        Encoder_Counter++;
}

float Rotary_Encoder::Calculate_Direction(void)
{
    while(Encoder_Counter < -1200)
        Encoder_Counter = Encoder_Counter + 1200;
    while(Encoder_Counter > 1200)
        Encoder_Counter = Encoder_Counter - 1200;
    
    if(Encoder_Counter <0 )
    {
        Direction_Numb = ((Encoder_Counter / 1200.0) * 360.0f )+ 360.0f;
    }
    else
    {
        Direction_Numb = (Encoder_Counter / 1200.0) * 360.0f;
    }
    
    return Direction_Numb;
}


char *Rotary_Encoder::Show_Direction_In_char(void)
{
    // Data processing    -2^32< "int" <2^32-1
    while(Encoder_Counter < -1275)
        Encoder_Counter = Encoder_Counter + 1200;
    while(Encoder_Counter > 1275)
        Encoder_Counter = Encoder_Counter - 1200;
    
    // Calculate the direction
    if(((-1275<=Encoder_Counter)&&(Encoder_Counter<=-1126)) ||  ((-76 <= Encoder_Counter)&&(Encoder_Counter <= 75)) || ((1126 <= Encoder_Counter)&&(Encoder_Counter <= 1275)))
        strcpy(Direction,"N");  // N 北
    else if (((76 <= Encoder_Counter)&&(Encoder_Counter <= 225)) || ((-1126 <= Encoder_Counter)&&(Encoder_Counter <= -975)))
        strcpy(Direction,"NE"); // NE 东北
    else if (((226 <= Encoder_Counter)&&(Encoder_Counter <= 375)) || ((-976 <= Encoder_Counter)&&(Encoder_Counter <= -825)))
        strcpy(Direction,"E");  // E  东
    else if (((376 <= Encoder_Counter)&&(Encoder_Counter <= 525)) || ((-826 <= Encoder_Counter)&&(Encoder_Counter <= -675)))
        strcpy(Direction,"SE"); // SE 东南
    else if (((526 <= Encoder_Counter)&&(Encoder_Counter <= 675)) || ((-676 <= Encoder_Counter)&&(Encoder_Counter <= -525)))
        strcpy(Direction,"S");  // S  南
    else if (((676 <= Encoder_Counter)&&(Encoder_Counter <= 825)) || ((-526 <= Encoder_Counter)&&(Encoder_Counter <= -375)))
        strcpy(Direction,"SW"); // SW 西南
    else if (((826 <= Encoder_Counter)&&(Encoder_Counter <= 975)) || ((-376 <= Encoder_Counter)&&(Encoder_Counter <= -225)))
        strcpy(Direction,"W");  // W  西
    else if (((927 <= Encoder_Counter)&&(Encoder_Counter <= 1125)) || ((-226 <= Encoder_Counter)&&(Encoder_Counter <= -75)))
        strcpy(Direction,"NW"); // NW 西北
    
    return Direction;
}



