#include "mbed.h"
#include "ThingSpeak_ESP8266.h"

#define SSID       "WIFI SSID"
#define Password   "WIFI PASSWORD"
#define API_Key    "YOUR API_KEY"

Serial PC(USBTX, USBRX, 115200);
ESP8266 WIFI(PC_10, PC_11, 115200);

void WIFI_init(void);

int main(void)
{
    int data = 0;

    WIFI_init();
    WIFI.User_API_Key = API_Key;
    
    while(1)
    {
        PC.printf("Send %2d", data);
        WIFI.Send_To_ThingSpeak_int(1, data);
        PC.printf(" Done\r\n");
        
        data++;
        wait(5);
    }
}

void WIFI_init(void)
{
        printf("\r\nReset ESP...");
        WIFI.Reset();
            
        printf("\r\nSet Mode...");
        WIFI.Set_Mode();
        
        printf("\r\nConnect WIFI....");
        WIFI.Connect_WIFI(SSID, Password);
}

