/*
    Copyright (c) 2019 Yifan DU
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
 
    
    1.0 14-Feb.-2019 - Initial release.
        
  *****************************************************************
  Attention: This drive don not have response
  *****************************************************************
  @code
  
#include "mbed.h"
#include "ThingSpeak_ESP8266.h"
    
#define SSID       "YOUR API_KEY"
#define Password   "WIFI SSID"
#define API_Key    "WIFI PASSWORD"
    
Serial PC(USBTX, USBRX, 115200);
ESP8266 WIFI(PC_10, PC_11, 115200);
    
void WIFI_init(void)
{
    printf("\r\nReset ESP...");
    WIFI.Reset();
                
    printf("\r\nSet Mode...");
    WIFI.Set_Mode();
            
    printf("\r\nConnect WIFI....");
    WIFI.Connect_WIFI(SSID, Password);
}
    
int main(void)
{
    int data = 0;
    
    WIFI_init();
    WIFI.User_API_Key = API_Key;
        
    while(1)
    {
        PC.printf("Send %2d", data);
        WIFI.Send_To_ThingSpeak_int(1, data);
        PC.printf(" Done\r\n");
            
        data++;
        wait(5);
    }
}

  @endcode
 *****************************************************************
*/

#ifndef _THINGSPEAK_ESP8266_H_
#define _THINGSPEAK_ESP8266_H_

#include "mbed.h"

class ESP8266
{
    public:
        char*  User_API_Key;
    
        ESP8266(PinName ESP_TX, PinName ESP_RX, int ESP_BR);
    
        void Reset(void);

        void Set_Mode(void);
    
        void Connect_WIFI(char *WIFI_SSID, char *WIFI_Password);
    
        void Send_To_ThingSpeak_int(int field, int Data);
    
        void Send_To_ThingSpeak_float(int field, float Data);
    
        void Send_To_ThingSpeak_char(int field, char* Data);
        
        bool Is_Success(void);
    
    private:
        Serial ESP;
        char*  ESP_Cmd;
        char   URL[300];
};

#endif
