#include "ThingSpeak_ESP8266.h"

ESP8266::ESP8266(PinName ESP_TX, PinName ESP_RX,int ESP_BR) : ESP(ESP_TX, ESP_RX)
{
    ESP.baud(ESP_BR);
}

void ESP8266::Reset(void)
{
    ESP.printf("AT+RST\r\n");
    wait(2);
}
    

void ESP8266::Set_Mode(void)
{
    ESP.printf("AT+CWMODE_CUR=1");
}

void ESP8266::Connect_WIFI(char *WIFI_SSID, char *WIFI_Password)
{
    sprintf(ESP_Cmd, "AT+CWJAP_CUR=\"%s\",\"%s\"\r\n", WIFI_SSID, WIFI_Password);
    ESP.printf(ESP_Cmd);
    wait(10);
}

void ESP8266::Send_To_ThingSpeak_int(int field, int Data)
{
    ESP.printf("AT+CIPSTART=\"TCP\",\"api.thingspeak.com\",80\r\n");
    wait(3);
    sprintf(URL, "GET https://api.thingspeak.com/update?api_key=%s&field%d=%d\r\n", User_API_Key,field, Data);
    ESP.printf("AT+CIPSEND=%d\r\n",strlen(URL));
    wait(2);
    ESP.printf(URL);
    wait(2);

}

void ESP8266::Send_To_ThingSpeak_float(int field, float data)
{
    ESP.printf("AT+CIPSTART=\"TCP\",\"api.thingspeak.com\",80\r\n");
    wait(3);
    sprintf(URL, "GET https://api.thingspeak.com/update?api_key=%s&field%d=%f\r\n", User_API_Key,field, data);
    ESP.printf("AT+CIPSEND=%d\r\n",strlen(URL));
    wait(2);
    ESP.printf(URL);
    wait(2);
}

void ESP8266::Send_To_ThingSpeak_char(int field, char* data)
{
    ESP.printf("AT+CIPSTART=\"TCP\",\"api.thingspeak.com\",80\r\n");
    wait(3);
    sprintf(URL, "GET https://api.thingspeak.com/update?api_key=%s&field%d=%s\r\n", User_API_Key,field, data);
    ESP.printf("AT+CIPSEND=%d\r\n",strlen(URL));
    wait(2);
    ESP.printf(URL);
    wait(2);
}




