#include "mbed.h"
#include "Thermal.h"
#include "USBHostKeyboard.h"
#include "uVGAIII.h"

#define SIZE_X       480
#define SIZE_Y       800

using namespace std;

// Debugging LEDs
DigitalOut led(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

uVGAIII ecran(p9,p10,p11); // serial tx, serial rx, reset pin;
Thermal printer(p28, p27, 19200);

int verticalCursor = 2;
int horizontalCursor = 0;

char currentLine[48];
int currentLineIndex = 0;

// hardcode plot x^2
void plot(void const *)
{
    int xOffset = 600;
    int yOffset = 260;
    int pastX = 0;
    int pastY = 0;
    int currentX = 0;
    int currentY = 0;
    
    for(double i = -20; i < 20; i++) {
        //evaluate();
        currentX = i*3 + xOffset;
        currentY = yOffset-(i*i);
        if(pastX == 0){
            pastX = currentX;
            pastY = currentY;
            continue;
        }
        //ecran.line(pastX, pastY, currentX, currentY, RED);
        //ecran.put_pixel(i*2 + xOffset, yOffset-(i*i),RED);
        pastX = currentX;
        pastY = currentY;
    }
    while(1) {
        Thread::wait(200);
    }
}

void onKeyCode(uint8_t key, uint8_t modifier) {
    
    led3 = 1;
    
    if(key == 0) {
        led3 = 0;
        return;
    }
    
    // Handle newline
    if(key == 0x0A) {
        
        // Check if going off end of screen
        if(verticalCursor > 37) {
            ecran.filled_rectangle(0, 0 , 399, 480, DGREY);
            verticalCursor = 0;
        } else {
            // Move cursor to newline
            verticalCursor+=2;
        }
        
        horizontalCursor = 0;
        
        ecran.move_cursor(verticalCursor, horizontalCursor);
         
        ecran.puts(currentLine);  
        printer.printf(currentLine);
        printer.feed(2);
        
        for(size_t i = 0; i < 48; i++) {
            currentLine[i] = NULL;
        }
        
        currentLineIndex = 0;
        
        led3 = 0;
        return;
    }
    
    if(key == 0x08)
    {
        if(currentLineIndex != 0)
        {
            currentLineIndex--;
            currentLine[currentLineIndex] = NULL;
        }
        led3 = 0;
        return;
    }
    
    // Move the cursor 1 character over
    //ecran.move_cursor(verticalCursor, horizontalCursor++);
    
    // Append character to curret line string
    currentLine[currentLineIndex] = (char)key;
    
    if(currentLineIndex < 47) {
        currentLineIndex++;
    }
    
    led3 = 0;
}

void keyboard_task(void const *) {
    
    USBHostKeyboard keyboard;
    
    while(1) {
        // try to connect a USB keyboard
        while(!keyboard.connect()) {
            Thread::wait(1);
        } 
        
        if(keyboard.connected()) led2 = 1;
        
        // When connected, attach handler called on keyboard event
        keyboard.attach(onKeyCode);
        
        // Wait until the keyboard is disconnected
        while(keyboard.connected())
            Thread::wait(1); 
            
        led2 = 0;
    }
}

int main() {    
    // Set up display
    ecran.baudrate(300000);
    ecran.screen_mode(LANDSCAPE);
    ecran.graphics_parameters(RESOLUTION, 2); 
    ecran.touch_status();
    //ecran.background_color(DGREY);
    ecran.background_color(WHITE);
    ecran.cls();

    ecran.move_cursor(0, 0);
    ecran.char_width('d');
    ecran.char_height('d');
    ecran.text_fgd_color(WHITE);
    ecran.text_bgd_color(DGREY);
    ecran.puts("Booting up...");   
    
    ecran.line(400, 0 , 400, 480, RED);
        
    // Use old style threading
    Thread keyboardTask(keyboard_task, NULL, osPriorityNormal, 256 * 4);
    
    ecran.move_cursor(2, 0);
    ecran.puts("Ready!");
    
    //printer.printf("Printing from main");
    //printer.feed(2);
    //printer.test();   
    
    // Clear currentLine array before using
    for(size_t i = 0; i < 48; i++) {
            currentLine[i] = NULL;
    }
        
    //Thread drawPlot(plot, NULL, osPriorityNormal, 256*4);
    
    while(1) {
        led=!led;
        Thread::wait(500); // Wait .5s in main thread
    }
}
