#include "../Sprites/sprite.h"
#include "worlds.h"
#include "world_maps.h"


world universe[NUM_WORLDS];
world* active_world; // I need to define world

//place all the sprites you want in your game here
sprite grass[NUM_WORLDS];
sprite mud[NUM_WORLDS];

void set_active_world(world* active_world, HashTable* newMap){
	active_world->world_map = newMap;
}

//initializate sprites
void initialize_sprites(void){
	int world_index;
	for( world_index = 0; world_index < NUM_WORLDS; world_index++){
		//this makes grass
		grass_tiles_constructor(&grass[world_index]);
		//this makes mud
		mud_tiles_constructor(&mud[world_index]);
	}
	
}

unsigned map_hash(unsigned key)
{
    return key % 97;
}


//this way - each key should be unique.
unsigned int genkey(char x, char y){
	return ((y << 8)|(x));
	
}

//each world needs its own hash table
void allocate_worlds(){
	int world_index;
	//give each world a hash table
	for( world_index = 0; world_index < NUM_WORLDS; world_index++){
		universe[world_index].world_map = createHashTable(map_hash, 97);
	}
}

//populate each worlds hash table
void populate_worlds(void){
	int world_index;
	int row_index;
	int col_index;
	int sprite_type;
	unsigned int key;

	for( world_index = 0; world_index < NUM_WORLDS; world_index++)
		for(row_index = 0; row_index < WORLD_HEIGHT*TILES_PER_SCREEN_VERTICAL; row_index++)
			for(col_index = 0; col_index < WORLD_WIDTH*TILES_PER_SCREEN_HORIZONTAL; col_index++){
				sprite_type = world_tile_array[world_index][row_index][col_index];
				if(sprite_type == ' ')
				continue;
				//insert the corresponding sprite symbol into the world map
				switch(sprite_type){
					case G:
						key = genkey(col_index, row_index); //generate key
						insertItem(universe[world_index].world_map, key, &grass[world_index]);//insert key and value
						break;
					case M:
						key = genkey(col_index, row_index); //generate key
						insertItem(universe[world_index].world_map, key, &mud[world_index]);//insert key and value
						break;
				}
			}
}

sprite* fetchSprite(int x, int y){
	return (sprite*)getItem(universe[0].world_map, genkey(x,y));

}
