#pragma once
#include "inputs.h"

MMA8452 acc(p28, p27, 100000);          // Accelerometer
DigitalIn button1(p21);                 // Pushbuttons (pin)
DigitalIn button2(p22);
DigitalIn button3(p24);

inputs in;

void inputs_init(void){
    button1.mode(PullUp); 
    button2.mode(PullUp);
    button3.mode(PullUp);
    }

int get_inputs(void){
    //read inputs
    in.b1 = !button1; // Inverted, because low voltage means "pressed"
    in.b2 = !button2;
    in.b3 = !button3;
    acc.readXYZGravity(&in.a_x, &in.a_y, &in.a_z); // Read gravity
    in.a_y = -in.a_y;   // Accelerometer is right handed, everything else is left handed
    
    //process inputs
        // First, check action buttons
    if (in.b1) return ACTION_BUTTON;
    if (in.b2) return BOMB_BUTTON;
    
    // Otherwise, compute motion
    double thresh = 0.2;
    if (fabs(in.a_x) + fabs(in.a_y) > thresh)
    {
        #define PI 3.1415926
        double angle = atan2(in.a_y, in.a_x); // value on [-pi, pi]
//        pc.printf("atan: %f\r\n", angle);
        if (angle > 3*PI/4 || angle < -3*PI/4) return GO_LEFT;
        else if (angle > PI/4) return GO_DOWN;
        else if (angle > -PI/4) return GO_RIGHT;
        else return GO_UP;
    }
    return NO_ACTION;

    }