#include "mbed.h"
#include "uLCD_4DGL.h"
#include "Sprites/main_character/main_character.h"
#include "hash_table/hash_table.h"
#include "worlds/worlds.h"
#include "inputs/inputs.h"

uLCD_4DGL uLCD(p9, p10, p11); //  serial tx, serial rx, reset pin;
Serial pc(USBTX, USBRX);



//key function
unsigned int genKey(unsigned int key){
	return key%97;
}

DigitalOut myled(LED2);

void initWorlds(void){
	initialize_sprites();
	allocate_worlds();
	populate_worlds();
}

int main() {
    //increase BAUD rate
    uLCD.baudrate(3000000);
    uLCD.background_color(WHITE);
	initWorlds();
	sprite* ret_sprite;
	inputs_init();

	
	for(int y = 0; y < 8; y+=1){
		for(int x = 0; x < 8; x+=1){
			//uLCD.BLIT(j,i,16,16,main_character.render.activeSkin);
			ret_sprite = (sprite*)fetchSprite(x,y);
			if(ret_sprite == NULL)
			continue;
			uLCD.BLIT(x*16,y*16,16,16,(*ret_sprite).render.activeSkin);

		}
	}

    main_character_constructor();
    //main_character_i();
    while(1) {
        myled = 1;
        wait(0.2);
        pc.printf("VALUE %d\r\n",get_inputs());
        myled = 0;
        wait(0.2);
    }
}
