#pragma once
#include "inputs.h"
#include <stdbool.h> 

//grass tile
#define G 1

//mud tile
#define M 2

//blank tile
#define _ ' '

typedef int *sprite_skins;

typedef struct{
    char depth;
	//only need x-y coordinates if the object is not static
    char x,y;

	//static objects
    //If the object is static
    int static_sprite;
	//how many instances of the static objects in a particular world are there
	int instances_in_world;

    //char num_skins;
    //sprite_skins activeSkin;
    int *activeSkin;
    
    } sprite_render;

typedef struct{
    bool walkable;
    bool breakable;
    bool meltable;
    bool pickupable;
	//to make it easier to insert sprites into world with initialization array
	//just type the letter you assigned to the sprite symbol into that array
	char sprite_id;
    } sprite_attributes;
    
typedef struct{
    int misc_states[10];
    } sprite_states;

typedef struct{
    void (*update)(inputs* );
    sprite_render render;
    sprite_attributes attributes;
    sprite_states state;
    } sprite;


// (*sprite1).skins[1]
