/**
 *
 */
 
#include <mbed.h>
#include <rtos.h>
#include "RTOSerrstr.h"

typedef struct {
    int32_t wait_signal;
    int32_t signal_flag;
} sig_table_t;

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);
Thread thread;
Semaphore sem;

volatile uint32_t signal;

static const sig_table_t tbl[] = {
    { 0x0000,  0x0000, },
    { 0x0000,  0x0001, },  
    { 0x0000,  0x0002, },
    { 0x0000,  0x0007, },      
    { 0x0000,  0x0080, },
    { 0x0000, 0x10000, },
    { 0x0001,  0x0001, },
    { 0x0003,  0x0001, },
    { 0x0003,  0x0002, },
    { 0x0001,  0x0003, },
    { 0x0002,  0x0000, },
    
};

void
signal_wait_thread(void const *argument)
{
    static uint32_t i = 0;
    osEvent evt;
    
    while (true) {
        signal = tbl[i].signal_flag;
        pc.printf("sig = 0x%08x 0x%03x\n", tbl[i].wait_signal, signal);
        sem.release();
        evt = Thread::signal_wait(tbl[i].wait_signal, 1000);
        if (evt.status != osOK) {
            pc.printf("%s\n", getOsStatusStr(evt.status));
        }
        //thread.signal_clr(signal);
        i++;
        if (i >= sizeof(tbl) / sizeof(sig_table_t)) {
            //i = 0;
            MBED_ASSERT(false);
        }
    }
}



int main()
{
    int32_t status;
    
    pc.baud(115200);
    pc.printf("signal test[%s %s]\n", __DATE__, __TIME__);

    thread.start(callback(signal_wait_thread, (void const *)NULL));   // start thread
    while(1) {
        sem.wait();
        myled = !myled;
        Thread::wait(1000);
        status = thread.signal_set(signal);
        if (status == 0x80000000) {
            pc.printf("signal_set(0x%04x) failed.\n", status);
        } else if (status != 0) {
            pc.printf("signal_set() returns 0x%08x.\n", status);
        }
    }
}
