#include "mbed.h"
//#include "rtos.h"
#include "main.hpp"
#include <string> 
#include "servo.hpp"
#include "uart.hpp"
#include "gun.hpp"
#include "led_color.hpp"
#include "mpu6050.hpp"

// включим режим тестирования гироскопа и акселерометра
#define MPU6050_TEST_ENABLED

using namespace std;

DigitalOut my_led(LED1); // светодиод на плате
StateLed MainStateLed; // для управления индикаторным светодиодом
Timer t2; // таймер для вывода раз в 0.5 сек данных акселерометра
int delt_tms = 0; 
int countms = 0; 

int main() {
    disabledGun(); // отключить пушку
    #ifndef MPU6050_TEST_ENABLED
    // инициалирация сервоприводов портит данные с гироскопа и акселерометра
    // поэтому для тестирования гироскопа отключим их
    initServo();
    #endif
    #ifdef MPU6050_TEST_ENABLED
    // инициализируем гироскоп и акселерометр
    initMPU6050();
    #endif
    // запустим таймер 
    t2.start();
    MainStateLed.setLedGreen(); // установим цвет индикаторного светодиода в зеленый
    // для вывода частоты (показывает 64 Мгц)
    //printf("SystemCoreClock = %d Hz\n\r", HAL_RCC_GetSysClockFreq());
    wait(2); // ждем две секунды
    while (true) {
        #ifdef MPU6050_TEST_ENABLED
        // опросим гироскоп и акселерометр
        mpu6050TimerInterrupt();
        #endif
        #ifndef MPU6050_TEST_ENABLED
        // обновим обработчик UART
        uartUpdate();
        #endif
        // проверим, прошло ли 0.5 секунд
        delt_tms = t2.read_ms() - countms;
        if (delt_tms > 500) {
            #ifdef MPU6050_TEST_ENABLED
            // выведем углы
            getMPU6050();
            #endif
            my_led = !my_led; //мигнем светодиодом
            countms = t2.read_ms(); 
        }
    }
    
}
 