#include "gun.hpp"
#include "mbed.h"
//#include "rtos.h"
#include "main.hpp"
#include "sounds.hpp"

DigitalOut gunPin(PIN_GUN);
PwmOut outSignalGun(PIN_OUT_SOUND);

void shotGun(void) {
    gunPin = 1;
    outSignalGun.period(1.0/1500.0); // 1500hz period
    outSignalGun = 0.5; //50% duty cycle - max volume
    wait(0.02);
    short tik = 0;
    char isStateGun = 1;
    for (short i = 0; i < 1500; i = i + 100) {
        outSignalGun.period(1.0/(float)(1500.0 - i)); 
        outSignalGun = 0.5;
        //Thread::wait(20);
        wait(0.02);
        if (tik < 3) {
            tik++;
        } else {
            tik = 0;
            isStateGun ^= 1;
            gunPin = isStateGun;
        }
    }
    outSignalGun = 0.0;
    //Thread::wait(200);
    gunPin = 0;
}

void enabledGun(void) {
    gunPin = 1;
}

void disabledGun(void) {
    gunPin = 0;
}