#include "led_color.hpp"
#include "mbed.h"
#include "main.hpp"

DigitalOut redLed(PIN_LED_RED);
DigitalOut greenLed(PIN_LED_GREEN);
DigitalOut blueLed(PIN_LED_BLUE);

// конструктор класса управления светодиодом состояния
StateLed::StateLed(void) {
    // по умолчанию светодиод выключен
    redLed = 0;
    greenLed = 0;
    blueLed = 0;
}

StateLed::~StateLed(void) {
    redLed = 0;
    greenLed = 0;
    blueLed = 0;
}

// функции устанавливают цвет светодиода
void StateLed::setLedRed(void) {
    redLed = 1;
    greenLed = 0;
    blueLed = 0;
}

void StateLed::setLedGreen(void) {
    redLed = 0;
    greenLed = 1;
    blueLed = 0;
}

void StateLed::setLedBlue(void) {
    redLed = 0;
    greenLed = 0;
    blueLed = 1;
}

void StateLed::setLedNull(void) {
    redLed = 0;
    greenLed = 0;
    blueLed = 0;
}

void StateLed::setLedWhite(void) {
    redLed = 1;
    greenLed = 1;
    blueLed = 1;
}
