#ifndef _STM32_WATCHDOG_TIMER_H
#define _STM32_WATCHDOG_TIMER_H

#include "mbed.h"

class WatchdogTimer {
    public:
    enum enumWatchdogTimer {
        RESET = 0,
        READY,
        BUSY,
        TIMEOUT,
        ERROR,
        UNKNOWN
    };
    WatchdogTimer();
    WatchdogTimer(float time);
    void setResponseTime_us(uint32_t time);
    void setResponseTime_ms(uint32_t time);
    void setResponseTime_s(uint32_t time);
    void setResponseTime(float time);
    void refresh(void);
    void start(void);
    enumWatchdogTimer getStatus(void);
    private: 
}; 

#endif // _STM32_WATCHDOG_TIMER_H