#include "AlternativeSoftwareI2C.hpp"
#include "stm32f1xx_hal.h"

#include "AlternativeDelay.hpp"
#include "mbed.h"

#define _delay_us delay_us 


SoftwareI2C::SoftwareI2C(GPIO_TypeDef* GPIOx_SCL, GPIO_TypeDef* GPIOx_SDA, uint16_t GPIO_PinScl, uint16_t GPIO_PinSda) {
    pinSDA = GPIO_PinSda;
    pinSCL = GPIO_PinScl;
    I2C_SDA_PORT = GPIOx_SDA;
    I2C_SCL_PORT = GPIOx_SCL;
    GPIO_InitTypeDef _GPIO_Init;
    __GPIOC_CLK_ENABLE();
    _GPIO_Init.Mode = GPIO_MODE_OUTPUT_OD; 
    _GPIO_Init.Pull = GPIO_NOPULL;
    _GPIO_Init.Pin = pinSDA | pinSCL;
    _GPIO_Init.Speed = GPIO_SPEED_FREQ_HIGH; 
    HAL_GPIO_Init(I2C_SCL_PORT, &_GPIO_Init);
    I2C_SDA_PORT->BSRR = pinSDA;//(1<<pinSDA);
    I2C_SCL_PORT->BSRR = pinSCL;//(1<<pinSCL);
    TimeX = 10; // Set 100 kBit/s
    initializeTimeDelays();
}

void SoftwareI2C::start(void) {
    I2C_SDA_PORT->BSRR = pinSDA;//(1<<I2C_SDA_PIN);
    _delay_us(TimeX);
    I2C_SCL_PORT->BSRR = pinSCL;//(1<<I2C_SCL_PIN);
    _delay_us(TimeX);
    while(!(I2C_SDA_PORT->IDR & pinSDA)) {
        I2C_SCL_PORT->BRR  = pinSCL;
        _delay_us(TimeX);
        I2C_SCL_PORT->BSRR = pinSCL;
        _delay_us(TimeX);
    }
    I2C_SDA_PORT->BRR = pinSDA;
    _delay_us(TimeX);
    I2C_SCL_PORT->BRR = pinSCL;
    _delay_us(TimeX);
}


void SoftwareI2C::stop(void) {
    I2C_SDA_PORT->BRR = pinSDA;
    _delay_us(TimeX);
    I2C_SCL_PORT->BSRR = pinSCL;
    _delay_us(TimeX);
    I2C_SDA_PORT->BSRR = pinSDA;
    _delay_us(TimeX);
}

uint8_t SoftwareI2C::write(uint8_t data) {
    uint8_t i;
    uint8_t ACK;
    for(i=0;i<8;i++) {
        if(data & 0x80) {
            I2C_SDA_PORT->BSRR = pinSDA;
        } else {
            I2C_SDA_PORT->BRR = pinSDA;
        }
        _delay_us(TimeX);
        I2C_SCL_PORT->BSRR = pinSCL;
        _delay_us(TimeX);        
        I2C_SCL_PORT->BRR = pinSCL;
        data=data<<1;    
    }
    _delay_us(TimeX);        
    I2C_SCL_PORT->BSRR = pinSCL;
    _delay_us(TimeX);        
    ACK = !(I2C_SDA_PORT->IDR & pinSDA);
    I2C_SCL_PORT->BRR = pinSCL;
    I2C_SDA_PORT->BRR = pinSDA;
    return ACK;
}

void SoftwareI2C::write(uint8_t address, uint8_t* data, uint8_t length) {
    uint8_t i ;
    start();
    write(address << 1);
    for(i = 0; i < length; i++) {
        write(data[i]);   
    }
    stop(); 
}

#if(0)
void SoftwareI2C::_delay_us(unsigned long delay) {
    volatile unsigned long i;
    for (i=0;i<delay;i++) {
        i++;
        i--;
    }
}
#endif
