#include "mbed.h"
#include "Stm32F1xxAlternative.hpp"


DigitalOut myled(LED1);

// Declare the legs of the microcontroller to work with the I2C software bus
#define _GPIO_Pin_9 (1<<9) // It is the 9 leg any port of the microcontroller
#define _GPIO_Pin_8 (1<<8) // It is the 8 leg any port of the microcontroller
// This is the class for working with the I2C software bus
// By default, the I2C frequency is 100 kHz
// In the example, the legs of the PC_9 microcontroller are used for SCL 
// and PC_8 for SDA (SCL port, SDA, port, SCL pin, SDA pin)
SoftwareI2C _i2c(GPIOC, GPIOC, _GPIO_Pin_9, _GPIO_Pin_8);


// Class for watchdog timer
#if (1)
// You can initialize as follows:
WatchdogTimer Watchdog(10.0);
#else
// Or you can initialize this way:
WatchdogTimer Watchdog();
#endif

// So you can find out the status of the watchdog timer
void WatchdogStatus(void) {
    switch (Watchdog.getStatus()) {
        case WatchdogTimer::RESET:       // IWDG not yet initialized or disabled
            printf("IWDG not yet initialized or disabled\r\n");
            break;
        case WatchdogTimer::READY:       // IWDG initialized and ready for use   
            printf("IIWDG initialized and ready for use\r\n");
            break;
        case WatchdogTimer::BUSY:        // IWDG internal process is ongoing 
            printf("IWDG internal process is ongoing\r\n");
            break;
        case WatchdogTimer::TIMEOUT:     // IWDG timeout state             
            printf("IWDG timeout state\r\n");
            break;
        case WatchdogTimer::ERROR:       // IWDG error state          
            printf("IWDG error state\r\n");
            break;
        default: 
            printf("Unknown state\r\n");
            break;
    }
}




int main() {
    #if (0)
    // You can pre-initialize an alternative time delay
    initializeTimeDelays();
    // Otherwise, initialization will be called automatically 
    // the first time you call the function delay_ms or delay_us
    #endif
    #if (0)
    // You can re-initialize the watchdog
    // The maximum time is 32 seconds
    Watchdog.setResponseTime_s(10);
    //Watchdog.setResponseTime_us(10000000);
    //Watchdog.setResponseTime_ms(10000);
    #endif
    // We get the state of the watchdog timer
    WatchdogStatus();
    // Run watchdog
    Watchdog.start();
    
    
    #if (1)
    // Example of using the software I2C
    uint8_t _addr = 0x4E;
    uint8_t _reg = 0x20;
    uint8_t _data = 0x55;
    _i2c.start(); // Signal start
    _i2c.write(_addr << 1); // Transfer the address of the device
    _i2c.write(_reg); // Transfer the number of the register
    _i2c.write(_data); // Write the data in the register
    _i2c.stop(); // 
    // You can also use this function
    // void write(uint8_t address, uint8_t* data, uint8_t length);
    #endif
    
    
    while(1) {
        myled = !myled;
        // This is an alternative delay for milliseconds
        // For microseconds, there is a function delay_us
        delay_ms(1000);
        // Update Watchdog
        // If this is not done, 
        // the watchdog timer will automatically reset the microcontroller
        Watchdog.refresh();
    }
}
