#include "SignalGenerator.h" // It includes 'mbed.h' header

/* CPU Available indicator
 */
DigitalOut g_availableLed(LED1); //<! Led used to indicate the program is alive
void AvailableLedIndicator(); //<! Ticker callback
Ticker g_available;

/* SignalGenerator usage
 */
SignalGenerator g_signal(p18);
void SynchronousUserInput(); //<! Ticker callback
Ticker g_synchronousUserInput;
Serial g_debug(USBTX, USBRX); //<! Needed to detect that the user pressed a key
SignalGenerator::SignalGeneratorType DisplaySignalGeneratorTestMenuAndGetChoice(); //<! User menu to select a signal type

/* Program Entry Point
 */
int main() {
    volatile SignalGenerator::SignalGeneratorType _choice; //<! User selects the desired signal type
    volatile int frequency; //<! Signal frequency
 
    wait(1); // Needed after startup
   
    // Launch available indicator
    g_availableLed = 1;
    g_available.attach(&AvailableLedIndicator, 2.0); // Never detached

    // Start infinite loop
    while(true)
    {
        // Acquire settings
        _choice = DisplaySignalGeneratorTestMenuAndGetChoice();
        printf("\r\nEnter signal frequency (< 1MHz/# of samples): ");
        scanf("%d", &frequency);

        // Prepare the signal
        g_signal.SetSignalFrequency(_choice, frequency);

        // Launch execution
        if (g_signal.BeginRunAsync() == -1) {
            // Synchronous mode
            g_synchronousUserInput.attach(&SynchronousUserInput, 0.005); // 5ms
            g_signal.Run(); // Never stopped
            printf("\r\nSignal Generator terminated\r\n");
            g_synchronousUserInput.detach();
        } else {
            // Asynchronous mode
            printf("\r\n\r\nPress any key to terminate\r\n");
            while (getchar() != 'q');
            g_signal.EndRunAsync();
        }
    } // End of 'while' statement
} // End of main program

/** Callbak used by CPU availabe ticker to indicate the program is alive
 */
void AvailableLedIndicator() {
    g_availableLed != g_availableLed;
} // End of function AvailableLedIndicator

/** Callbak used when SignalLibrary is used in synchronous mode (Run() method)
 */
void SynchronousUserInput() {
    if (g_debug.readable()) {
        g_signal.Stop();
        getchar();
    }
} // End of function SynchronousUserInput

/** Display the user menu
 */
SignalGenerator::SignalGeneratorType DisplaySignalGeneratorTestMenuAndGetChoice()
{
    do {
        printf("\r\n\r\nTest demo v0.1 - Generate signal\r\n");
        printf("\tSquareSignal:\t0\r\n");
        printf("\tTriangleSignal:\t1\r\n");
        printf("\tSawtoothSignal:\t2\r\n");
        printf("\tReverse sawtoothSignal:\t3\r\n");
        printf("\tSinusSignal:\t4\r\n");
        switch (getchar()) {
            case '0' :
                return SignalGenerator::SquareSignal;
            case '1' :
                return SignalGenerator::TriangleSignal;
            case '2' :
                return SignalGenerator::SawtoothSignal;
            case '3' :
                return SignalGenerator::ReverseSawtoothSignal;
            case '4' :
                return SignalGenerator::SinusSignal;
        } // End of 'switch' statement
    } while (true);
} // End of function DisplaySignalGeneratorTestMenuAndGetChoice
