#include <string>
#include <iostream>
#include <iomanip>

/**
 * Tests were done with schema proposed here: DS11195C-page 11 FIGURE 2-25: Potentiometer Divider Non-Linearity Error Test Circuit (DNL, INL)
 */
#include "MCP4xxxx_SPI.h"

struct UserChoice {
    char choice;
    unsigned char moduleId;
};

/*
 * Declare functions
 */
void AvailableIndicator(); // LED1 flashing for program while program is alive
UserChoice DisplayMenuAndGetChoice(); // Display and get the user choice

/*
 * Declare statics
 */
DigitalOut g_availableLed(LED1); // To verify if program in running
Ticker g_available; // LED1 will flash with a period of 2s
#define __MANAGE_CS__ // /CS managed by application
#undef  __MANAGE_CS__ // /CS managed by library
#if defined(__MANAGE_CS__)
DigitalOut g_chipSelect(p8); // /CS to select MCP4xxxx device
CMCP4xxxx_SPI g_digitalPot(p5, p6, p7, NC, NC, NC); // Create an instance of the class CMCP4xxxx_SPI, p5/p6/p7: SPI#1, /CS managed by application, /RESET input not connected, , /SHDN input not connected
#else // __MANAGE_CS__
CMCP4xxxx_SPI g_digitalPot(p5, p6, p7, p8, NC, NC); // Create an instance of the class CMCP4xxxx_SPI, p5/p6/p7: SPI#1, /CS managed by library, /RESET input not connected, , /SHDN input not connected
#endif // __MANAGE_CS__
UserChoice g_userChoice; // Used to store user choice from displayed menu

int main() {

    unsigned char potLevel = 0x80; // Initial digital potentiometer value
    
#if defined(__MANAGE_CS__)
    g_chipSelect.write(1); // Disable chip
#endif // __MANAGE_CS__

    // Launch available indicator
    g_available.attach(&AvailableIndicator, 2.0);
    
    while (true) {
    
        g_userChoice = DisplayMenuAndGetChoice(); // Retrieve the user selection
         switch (g_userChoice.choice) {
            case 'a':
                potLevel += 1;
#if defined(__MANAGE_CS__)
                g_chipSelect.write(0);
#endif // __MANAGE_CS__
                g_digitalPot.Write(CMCP4xxxx_SPI::WriteToPot1, potLevel);
#if defined(__MANAGE_CS__)
                g_chipSelect.write(1);
#endif // __MANAGE_CS__
                break;
            case 'b':
                potLevel += 1;
#if defined(__MANAGE_CS__)
                g_chipSelect.write(0);
#endif // __MANAGE_CS__
                g_digitalPot.Write(CMCP4xxxx_SPI::WriteToPot2, potLevel);
#if defined(__MANAGE_CS__)
                g_chipSelect.write(1);
#endif // __MANAGE_CS__
               break;
            case 'c':
                potLevel -= 1;
#if defined(__MANAGE_CS__)
                g_chipSelect.write(0);
#endif // __MANAGE_CS__
                g_digitalPot.Write(CMCP4xxxx_SPI::WriteToPot1, potLevel);
#if defined(__MANAGE_CS__)
                g_chipSelect.write(1);
#endif // __MANAGE_CS__
                break;
            case 'd':
                potLevel -= 1;
#if defined(__MANAGE_CS__)
                g_chipSelect.write(0);
#endif // __MANAGE_CS__
                g_digitalPot.Write(CMCP4xxxx_SPI::WriteToPot2, potLevel);
#if defined(__MANAGE_CS__)
                g_chipSelect.write(1);
#endif // __MANAGE_CS__
                break;
            case 'e':
                potLevel -= 1;
#if defined(__MANAGE_CS__)
                g_chipSelect.write(0);
#endif // __MANAGE_CS__
                g_digitalPot.Write(CMCP4xxxx_SPI::ShutdownPot1);
#if defined(__MANAGE_CS__)
                g_chipSelect.write(1);
#endif // __MANAGE_CS__
                break;
            case 'f':
                potLevel -= 1;
#if defined(__MANAGE_CS__)
                g_chipSelect.write(0);
#endif // __MANAGE_CS__
                g_digitalPot.Write(CMCP4xxxx_SPI::ShutdownPot2);
 #if defined(__MANAGE_CS__)
                g_chipSelect.write(1);
#endif // __MANAGE_CS__
                break;
            case 'r':
                g_digitalPot.Reset();
                break;
            default:
                std::cout << "Invalid user choice\r" << std::endl;
                break;
         } // End of 'switch' statement
       
    } // End of 'while' statement
} // End of program - nerver reached

void AvailableIndicator() {
    g_availableLed = !g_availableLed;
} // End of AvailableIndicator

UserChoice DisplayMenuAndGetChoice() {
    static UserChoice userChoice;

    // Display the title
    std::cout << "\r" << std::endl << "MCP4xxxx_SPI v0.1\r" << std::endl;

    // Display the menu
    std::cout << "\tIncrease level on pot #1:\t\t\ta\r" << std::endl;
    std::cout << "\tIncrease level on pot #2:\t\t\tb\r" << std::endl;
    std::cout << "\tDecrease level on pot #1:\t\t\tc\r" << std::endl;
    std::cout << "\tDecrease level on pot #2:\t\t\td\r" << std::endl;
    std::cout << "\tShutdown pot #1         :\t\t\te\r" << std::endl;
    std::cout << "\tShutdown pot #2         :\t\t\tf\r" << std::endl;
    std::cout << "\tReset MCP4xxxx          :\t\t\tr\r" << std::endl;
    std::cout << "Enter your choice: " << std::flush;
    userChoice.choice = getchar();
    // Display the menu
    std::cout << "\r" << std::endl << std::flush;
    return userChoice;
}
