#include <string>
#include <iostream>
#include <iomanip>

#include "MCP23017_I2C.h"

/*
 * Declare functions
 */
void AvailableIndicator(); // LED1 flashing for program while program is alive
DigitalOut g_availableLed(LED1); // To verify if program in running
Ticker g_available; // LED1 will flash with a period of 2s
char DisplayMenuAndGetChoice();
void GpioAIntr(); // Interrupt on GPIOA

static CMCP23017_I2C g_gpioExp(p9, p10, 0x27, p15, p16, p17);

int main() {
    // Launch available indicator
    g_available.attach(&AvailableIndicator, 2.0);
    
    g_gpioExp.Initialize(0x01); // GpioA<0> as input port, no interrupt mirroring, Active low  
    g_gpioExp.setupInterruptPin(GPA0, AbstractGpioExpender::OnFalling); // A switch with pull-up is connected to GPIOA<0>, interrupt on falling mode
    g_gpioExp.setIntrACallback(GpioAIntr); // Set callback for interrup on GPIOA<0>

    while(true) {
        switch (DisplayMenuAndGetChoice()) {
            case 'a':
                g_gpioExp.write(GPB0, 1);
                break;
            case 'b':
                g_gpioExp.write(GPB0, 0);
                break;
            case 'c':
                g_gpioExp.write(GPB2, 1);
                break;
            case 'd':
                g_gpioExp.write(GPB2, 0);
                break;
            case 'e':
                g_gpioExp.write(GPB3, 1);
                break;
            case 'f':
                g_gpioExp.write(GPB3, 0);
                break;
            case 'g':
                g_gpioExp.write(GPB4, 1);
                break;
            case 'h':
                g_gpioExp.write(GPB4, 0);
                break;
            case 'i':
                g_gpioExp.write(GPB7, 1);
                break;
            case 'j':
                g_gpioExp.write(GPB7, 0);
                break;
            case 'r':
                g_gpioExp.reset();
                break;
            case 's': {
                    std::list<unsigned char> lcdBus;
                    lcdBus.push_back(GPA7); // First item in the list
                    lcdBus.push_back(GPA6);
                    lcdBus.push_back(GPA5);
                    lcdBus.push_back(GPA4);
                    unsigned char busId = g_gpioExp.createBus(lcdBus);
                    g_gpioExp.busWrite(busId, 0x000A); // GPA7=1, GPA6=0, GPA5=1, GPA4=0 - LSB is GPB4, MSB is GPA7
                    wait_us(20);
                    g_gpioExp.busWrite(busId, 0x0000); // GPA7=1, GPA6=0, GPA5=1, GPA4=0
                    wait_us(20);
                    g_gpioExp.deleteBus(busId);
                }
                break;
            default:
                std::cout << "Invalid user choice\r" << std::endl;
                break;
        } // End of 'switch' statement
        
    } // End of 'while' loop
}

void AvailableIndicator()
{
    g_availableLed = !g_availableLed;
} // End of AvailableIndicator

char DisplayMenuAndGetChoice()
{
    char value;
    std::cout << "\r" << std::endl << "\r" << std::endl << "MCP23017_I2C v0.1\r" << std::endl;
    std::cout << "\tSet MUX_EN1 (PortB-0)     :\t\ta\r" << std::endl;
    std::cout << "\tUnset MUX_EN1 (PortB-0)   :\t\tb\r" << std::endl;
    std::cout << "\tSet MUX_ADDR0 (PortB-2)   :\t\tc\r" << std::endl;
    std::cout << "\tUnset MUX_ADDR0 (PortB-2) :\t\td\r" << std::endl;
    std::cout << "\tSet MUX_ADDR1 (PortB-3)   :\t\te\r" << std::endl;
    std::cout << "\tUnset MUX_ADDR1 (PortB-3) :\t\tf\r" << std::endl;
    std::cout << "\tSet MUX_ADDR2 (PortB-4)   :\t\tg\r" << std::endl;
    std::cout << "\tUnset MUX_ADDR2 (PortB-4) :\t\th\r" << std::endl;
    std::cout << "\tSet BOARD_EN (PortB-7)    :\t\ti\r" << std::endl;
    std::cout << "\tUnset BOARD_EN (PortB-7)  :\t\tj\r" << std::endl;
    std::cout << "\tReset device              :\t\tr\r" << std::endl;
    std::cout << "\tBus test                  :\t\ts\r" << std::endl;
    std::cout << "Enter your choice: " << std::flush;
    value = getchar(); 
    std::cout << "\r" << std::endl;
    return value;
}

void GpioAIntr() {
    unsigned char gpioId, gpioValue;
    wait(0.6); // Debounce timer
    g_gpioExp.getLastInterruptPinAndValue(&gpioId, &gpioValue); // Get interrupt info and clear it
    std::cout << "\r" << std::endl << "GpioAIntr: interrupt on pin #" << std::hex << std::setw(2) << std::setfill('0') << static_cast<unsigned int>(gpioId) << " - value: " << static_cast<unsigned int>(gpioValue) << "\r" << std::endl;
}

