/* mbed simplified access to RAMTRON FV24xx Serial 3V F-RAM Memory (I2C)
 * Copyright (c) 2013 ygarcia, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#if !defined(__FM24VXX_IDS_H__)
#define __FM24VXX_IDS_H__

#include <mbed.h>

namespace _FM24VXX_I2C {

/**
 * Device ID description
 * @remark See FM24V10_ds Figure 14. Manufacturer and Product ID
 */
class CFM24VXX_IDs {

    /** Device ID description
     */
    struct { // FM24V10_ds Figure 14. Manufacturer and Product ID
        unsigned char manufacturerID;
        union {
            unsigned char id;
            struct {
                unsigned char variation:4;
                unsigned char density:4;
            } vd;
        } productID;
        struct {
            unsigned char dierev:3;
            unsigned char reserved:5;
        } dieRevision;
    } _deviceID;
    
    public:
        inline CFM24VXX_IDs(const unsigned char manufacturerID, const unsigned char productID, const unsigned char dieRevision) {
            _deviceID.manufacturerID = manufacturerID;
            _deviceID.productID.id = productID;
            _deviceID.dieRevision.dierev = dieRevision & 0x07; // FM24V10_ds Figure 14. Manufacturer and Product ID
        } // End of Constructor
        
        inline unsigned char GetManufacturerID() const { return _deviceID.manufacturerID; };
        
        inline unsigned char GetProductID() const { return _deviceID.productID.id; };
        
        inline unsigned char GetRevisionID() const { return _deviceID.dieRevision.dierev; };
        
        inline unsigned char GetDensity() const { return _deviceID.productID.vd.density >> 4; };
        
        inline unsigned char GetVariation() const { return _deviceID.productID.vd.variation; };
        
}; // End of class CFM24VXX_IDs

} // End of namespace _FM24VXX_I2C

#endif // __FM24VXX_IDS_H__
