/* mbed simplified access to RAMTRON FV24xx Serial 3V F-RAM Memory (I2C)
 * Copyright (c) 2013 ygarcia, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#if !defined(__FM24VXX_SN_H__)
#define __FM24VXX_SN_H__

#include <mbed.h>
//#include "Debug.h"

namespace _FM24VXX_I2C {

/**
 * Device ID description
 * @remark See FM24V10_ds Figure 14. Manufacturer and Product ID
 */
class CFM24VXX_SN {

    /** Serial number description
     */
    union { // See FM24V10_ds Figure 15. 8-Byte Serial Number (read-only)
        unsigned char snumber[8];
        struct {
            unsigned char crc;
            unsigned char un[5];
            unsigned char cid[2];
        } sn;
    } _sn;
    
    public:
        inline CFM24VXX_SN(const unsigned char *pdatas) {
//            for (int i = 0; i < 8; i++) {
//                DEBUG("CFM24VXX_SN::CFM24VXX_SN: byte #%d = 0x%02x", i, *(pdatas + i))
//            }
            memcpy((void *)&(_sn.snumber[0]), pdatas, 8 * sizeof(unsigned char));
        } // End of Constructor
        
        inline unsigned short GetCustomerID() const { return _sn.sn.cid[0] << 8 | _sn.sn.cid[1]; };
        
        inline unsigned char * GetUniqueID() const { return (unsigned char *)&(_sn.sn.un[0]); };
        
        inline unsigned char GetChecksum() const { return _sn.sn.crc; };
        
}; // End of class CFM24VXX_SN

} // End of namespace _FM24VXX_I2C

#endif // __FM24VXX_SN_H__
