
// インヒビットスイッチ動作確認用プログラム
// BBM board No.1 - Inhibit Control Unit
// リセットボタンを押すと10秒後にインヒビットスイッチを三つともONにする
#include "mbed.h"
Serial pc(USBTX,USBRX);
DigitalOut SW1_on(p21), SW2_on(p22), SW3_on(p23), SW1_off(p24), SW2_off(p25), SW3_off(p26);
DigitalOut myleds[] = {LED1, LED2, LED3, LED4};
int main() {
     pc.printf("Turn on the inhibit switch after 5[sec.] \r\n");
     for(int i=0;i<5;i++){
          if (i == 1){
               myleds[0] = 1;
          }else if (i == 2){
               myleds[1] = 1;
          }else if (i == 3){
               myleds[2] = 1;
          }else if (i == 4){
               myleds[3] = 1;
          }
          pc.printf("%d[sec]\r\n",i+1);
          wait(1.0);
     }
     pc.printf("Switch ON \r\n");
     SW1_on = 1;
     wait(0.2);
     SW2_on = 1;
     wait(0.2);
     SW3_on = 1;
     wait(1.0);
     SW1_on = SW2_on = SW3_on = 0;
     char cmd;
     cmd = pc.getc();
     if(cmd == 'd'){
         printf("Switch OFF \r\n");
     SW1_off = 1;
     wait(0.2);
     SW2_off = 1;
     wait(0.2);
     SW3_off = 1;
     wait(1.0);
     SW1_off = SW2_off = SW3_off = 0;
     myleds[0] = myleds[1] = myleds[2] = myleds[3] = 0;
     }
}
