#include "mbed.h"
#include "MH_Z19.h"

MH_Z19 Sen(p5);
Serial CO2(p9,p10);
 
DigitalOut condition(LED1);
Serial gs(USBTX,USBRX); // for ground station
Timer nodetime;
int rcmd=0,cmdflag=0;
int rco2=0,co2flag=0;
int co2val[2] = {0};
int co2_command[9] = {0};
int co2str[9] = {0};
int p = 0;

void commandget()
{
    rcmd=gs.getc();
    cmdflag=1;
}
void receive(int rcmd,int cmdflag)
{
    gs.attach(commandget,Serial::RxIrq); 
}
void initialize()
{
    rcmd = 0;
    cmdflag = 0;
    condition = 0;
}
       
void co2get()
{
    rco2=CO2.getc();
    co2str[p++] = rco2;
    co2flag=1;
}
    
void receive_CO2(int rco2,int co2flag)
{
    CO2.attach(co2get,Serial::RxIrq);
}

void initialize_CO2()
{
        rco2 = 0;
        co2flag = 0;
        p = 0;
}

int main()
{
  //gs.printf("From node: Nominal Operation\r\n");
  CO2.baud(9600);
  nodetime.start();
  receive(rcmd,cmdflag);
  receive_CO2(rco2,co2flag);
  initialize();
  while(1){
    condition=!condition;
    
    //gs.printf("CO2NODE::Time=%f[s], CO2bytes= %d %d \r\n",nodetime.read(),co2val[0],co2val[1]);
    //wait_ms(1000);
    
    if(cmdflag==1){
        if(rcmd=='a'){
        // get CO2 data
            //gs.printf("Command a received\r\n ");
            // setup MH-Z19C command string
            co2_command[0] = 0xff;
            co2_command[1] = 0x01;
            co2_command[2] = 0x86;
            co2_command[3] = 0x00;
            co2_command[4] = 0x00;
            co2_command[5] = 0x00;
            co2_command[6] = 0x00;
            co2_command[7] = 0x00;
            co2_command[8] = 0x79;
            for(int k = 0 ; k<9; k++){
                CO2.putc(co2_command[k]);
            }
            wait_ms(100);
            if(co2flag==1){
                gs.printf("CO2 = %04d [ppm]\r\n",(co2str[2]*256)+co2str[1]);
                //gs.printf("CO2 received: %x,%x,%x,%x,%x,%x,%x,%x,%x",co2str[0],co2str[1],co2str[2],co2str[3],co2str[4],co2str[5],co2str[6],co2str[7],co2str[8]);
                /*
                gs.putc(co2str[2]);
                gs.putc(co2str[3]);
                gs.putc(13);
                gs.putc(10);
                */
                initialize_CO2();
            }
            
        }else if(rcmd=='c'){
        // do calibration
            gs.printf("Command c received\r\n ");
        }
        initialize();
    }
  }
  nodetime.stop();
  gs.printf("From Sat: Endof Operation \r \n");
}

