/* mbed MH-Z19 Library
 * Copyright (c) 2016, zeus3110
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef MH_Z19_H
#define MH_Z19_H

#include "mbed.h"

#define PWM_CYCLE_MS 1004
#define CO2_MAX_PPM 5000

class MH_Z19 {
public:
    /** Create a MH_Z19
     *
     * @param Port The pwm input pin (must support InterruptIn)
     */ 
    MH_Z19(PinName Port);

    int ReadCO2PPM();

protected:        
    void rise();
    void fall();
    
    InterruptIn Port;
    Timer T;
    int OnWidth;
};

#endif


