#include "mbed.h"
#include "HEPTA_CDH.h"
#include "HEPTA_EPS.h"
#include "HEPTA_SENSOR.h"
#include "HEPTA_COM.h"

//SWUART
#define SW_BAUD_RATE    9600.0//19200.0
#define IN_BUF_SIZE     256
#define TRUE 1
#define FALSE 0

HEPTA_CDH cdh(p5, p6, p7, p8, "sd");
HEPTA_EPS eps(p16,p26);
HEPTA_SENSOR sensor(p17,
                  p28,p27,0x19,0x69,0x13,
                  p13, p14,p25,p24);
HEPTA_COM com(p9,p10);
DigitalOut condition(LED1);
DigitalOut LandLED1(p29);
DigitalOut LandLED2(p30);
DigitalOut LandLED3(p11);
DigitalOut LandLED4(p12);

Serial sat(USBTX,USBRX,9600);
Timer sattime;
int rcmd = 0,cmdflag = 0; //command variable

//SWUART
//Digital pins for SW-UART
DigitalOut swTX(p23);
DigitalIn swRX(p22);

DigitalOut debug2(LED2);
DigitalOut debug3(LED3);
DigitalOut debug4(LED4);

//Ticker for baudrate
Ticker br_tick;

static unsigned char        inbuf[IN_BUF_SIZE];
static unsigned char        qin = 0;
static unsigned char        qout = 0;
 
static char             flag_rx_waiting_for_stop_bit;
static char             flag_rx_off;
static char             rx_mask;
static char             flag_rx_ready;
static char             flag_tx_ready;
static char             timer_rx_ctr;
static char             timer_tx_ctr;
static char             bits_left_in_rx;
static char             bits_left_in_tx;
static char             rx_num_of_bits;
static char             tx_num_of_bits;
static int              internal_rx_buffer;
static int              internal_tx_buffer;
static int              user_tx_buffer;
 
float b_rate = 0.0; 
int co2ppm = 0;
char co2_str[9] = {0};
char mybit = 0;

//Interface routines by AB
//    Returns 0 or 1 dependent on whether the receive pin is high or low.
int get_rx_pin_status(void){
    if(swRX == 1)
        return 1;
    else
        return 0;
}

//    Background functions to execute while waiting for input.
void idle(void){
    ;
}

//    Sets the timer to 3 times the baud rate.
void timer_set( float the_rate ){
    //b_rate = 1/(3*the_rate);
    b_rate = 1/the_rate;
}

//    Enables the timer interrupt.
/*
void set_timer_interrupt( int the_isr )
{
    br_tick.attach(&the_isr, b_rate);
}
*/


 
void swuart_isr(void)
    {

    // AB transmit
    if ( flag_tx_ready ){
        if (mybit == 0)
            swTX = 0;
        else
            swTX = 1;
        flag_tx_ready = FALSE;
    }
/*    char            mask, start_bit, flag_in;
    //debug4 != debug4;
// Transmitter Section
    if ( flag_tx_ready )
        {
        if ( --timer_tx_ctr<=0 )
            {
            //debug4 = 1;
            mask = internal_tx_buffer&0x1;
            //sat.printf("%d,%d",mask,bits_left_in_tx);
            internal_tx_buffer >>= 1;
            if ( mask == 1 )
                {
                swTX = 1;
                }
            else
                {
                swTX = 0;
                }
            timer_tx_ctr = 3;
            if ( --bits_left_in_tx<=0 )
                {
                flag_tx_ready = FALSE;
                }
            }
        }
// Receiver Section
/*
    if ( flag_rx_off==FALSE )
        {
        if ( flag_rx_waiting_for_stop_bit )
            {
            if ( --timer_rx_ctr<=0 )
                {
                flag_rx_waiting_for_stop_bit = FALSE;
                flag_rx_ready = FALSE;
                internal_rx_buffer &= 0xFF;
                if ( internal_rx_buffer!=0xC2 )
                    {
                    inbuf[qin] = internal_rx_buffer;
                    if ( ++qin>=IN_BUF_SIZE )
                        {
                        qin = 0;
                        }
                    }
                }
            }
        else        // rx_test_busy
            {
            if ( flag_rx_ready==FALSE )
                {
                start_bit = get_rx_pin_status();
// Test for Start Bit
                if ( start_bit==0 )
                    {
                    flag_rx_ready = TRUE;
                    internal_rx_buffer = 0;
                    timer_rx_ctr = 4;
                    bits_left_in_rx = rx_num_of_bits;
                    rx_mask = 1;
                    }
                }
            else    // rx_busy
                {
                if ( --timer_rx_ctr<=0 )
                    {               // rcv
                    timer_rx_ctr = 3;
                    flag_in = get_rx_pin_status();
                    if ( flag_in )
                        {
                        internal_rx_buffer |= rx_mask;
                        }
                    rx_mask <<= 1;
                    if ( --bits_left_in_rx<=0 )
                        {
                        flag_rx_waiting_for_stop_bit = TRUE;
                        }
                    }
                }
            }
        }
    */
    }
 
void init_swuart( void )
{
    flag_tx_ready = FALSE;
    flag_rx_ready = FALSE;
    flag_rx_waiting_for_stop_bit = FALSE;
    flag_rx_off = TRUE;  // Start with receiver off FALSE;
    rx_num_of_bits = 10;
    tx_num_of_bits = 10;
 
    swTX = 1;  // start with TX line high
    timer_set( SW_BAUD_RATE );
    br_tick.attach(&swuart_isr, b_rate);
 }
 
char _swgetchar( void )
{
    char        ch;
 
    do
        {
        while ( qout==qin )
            {
            idle();
            }
        ch = inbuf[qout] & 0xFF;
        if ( ++qout>=IN_BUF_SIZE )
            {
            qout = 0;
            }
        }
    while ( ch==0x0A || ch==0xC2 );
    return( ch );
}
 
void _swputchar( char ch )
{
    ch  = (ch<<1)|0x200;
    sat.printf("ch=%x",ch);    
    for(int i = 0; i < 10; i++){
        while ( flag_tx_ready == 1);
        ch = ch >> 1;
        mybit = ch & 0x1;
        flag_tx_ready = TRUE;
    }
    sat.printf("putchar done");
    //debug2 = 1;
/*    while ( flag_tx_ready ){
        sat.printf("waiting for TX to complete ...\r\n");
    }
    user_tx_buffer = ch;
 
// invoke_UART_transmit
    bits_left_in_tx = tx_num_of_bits;
    internal_tx_buffer = (user_tx_buffer<<1) | 0x200;
    timer_tx_ctr = 3;
    flag_tx_ready = TRUE;
    //debug2 = 0;
*/
}
 
void flush_input_buffer( void )
{
    qin = 0;
    qout = 0;
}
 
char kbhit( void )
{
    return( qin!=qout );
}
 
void turn_rx_on( void )
{
    flag_rx_off = FALSE;
}
 
void turn_rx_off( void )
{
    flag_rx_off = TRUE;
}

void read_co2( void ){
    // write to MH-Z19C

    _swputchar( 0xa5 );
    _swputchar( 0x33 );

    //sat.printf("ch1");
    _swputchar( 0xff );
    //sat.printf("ch2");
    _swputchar( 0x01 );
    _swputchar( 0x86 );
    _swputchar( 0x00 );
    _swputchar( 0x00 );
    _swputchar( 0x00 );
    _swputchar( 0x00 );
    _swputchar( 0x00 );
    _swputchar( 0x79 );
    wait_ms(100);
    sat.printf("TX done");
    for(int i=0; i<9;i++){
        co2_str[i] = _swgetchar();
    }
    
    turn_rx_on();
    
    for(int i=0; i<9;i++){
        sat.printf("%02x",co2_str[i]);
    }
}



int main() {
    
    debug2 = 1;
    debug3 = 1;
    debug4 = 1;
    wait_ms(500);
    debug2 = 0;
    debug3 = 0;
    debug4 = 0;
    wait_ms(500);
    debug2 = 1;
    debug3 = 1;
    debug4 = 1;
    wait_ms(500);
    debug2 = 0;
    debug3 = 0;
    debug4 = 0;
    wait_ms(500);
    debug2 = 1;
    debug3 = 1;
    debug4 = 1;
    wait_ms(500);
    debug2 = 0;
    debug3 = 0;
    debug4 = 0;
    wait_ms(500);
    
    turn_rx_off();
    init_swuart();
    
    LandLED1 = 1;
    LandLED2 = 1;
    LandLED3 = 1;
    LandLED4 = 1;
    sat.printf("From Sat : Nominal Operation\r\n");
    com.printf("From Sat : Nominal Operation\r\n");
    com.baud(9600);
    int flag = 0; //condition flag
    float batvol, temp; //voltage, temperature 
    int rcmd=0,cmdflag=0;  //command variable
    float ax,ay,az;
    float gx,gy,gz;
    
    sattime.start();
    eps.turn_on_regulator();//turn on 3.3V conveter
    while(1) {
        com.xbee_receive(&rcmd,&cmdflag);//interupting by ground station command
        
        //satellite condition led
        condition = !condition;
        
        //senssing HK data(dummy data)
        eps.vol(&batvol);
        sensor.temp_sense(&temp);
        
        //Transmitting HK data to Ground Station(GS)
        com.printf("HEPTASAT::Condition = %d, Time = %f [s], batVol = %.2f [V],Temp = %.2f [C]\r\n",flag,sattime.read(),batvol,temp);
        wait_ms(1000);
        LandLED1 = ! LandLED1;                
        LandLED2 = ! LandLED2;                
        LandLED3 = ! LandLED3;                
        LandLED4 = ! LandLED4;                
        //Power Saving Mode 
        if((batvol <= 3.5)  | (temp > 35.0)){
            eps.shut_down_regulator();
            com.printf("Power saving mode ON\r\n"); 
            flag = 1;
        } else if((flag == 1) & (batvol > 3.7) & (temp <= 25.0)) {
            eps.turn_on_regulator();
            com.printf("Power saving mode OFF\r\n");
            flag = 0;
        }
        //Contents of command
        if (cmdflag == 1) {
            if (rcmd == 'a') {
                sat.printf("rcmd=%c,cmdflag=%d\r\n",rcmd,cmdflag);
                com.printf("Hepta-Sat Uplink Ok\r\n");
                for(int j=0;j<5;j++){
                    com.printf("Hello World!\r\n");
                    condition = 1;
                    wait_ms(1000);
                }
            }else if (rcmd == 'b') {
                sat.printf("rcmd=%c,cmdflag=%d\r\n",rcmd,cmdflag);
                com.printf("Hepta-Sat Uplink Ok\r\n");
                char str[100];
                mkdir("/sd/mydir", 0777);
                FILE *fp = fopen("/sd/mydir/satdata.txt","w");
                if(fp == NULL) {
                    error("Could not open file for write\r\n");
                }
                for(int i = 0; i < 10; i++) {
                    eps.vol(&batvol);
                    fprintf(fp,"%f\r\n",batvol);
                    condition = 1;
                    wait_ms(1000);
                }
                fclose(fp);
                fp = fopen("/sd/mydir/satdata.txt","r");
                for(int i = 0; i < 10; i++) {
                    fgets(str,100,fp);
                    com.puts(str);
                }
                fclose(fp);                
            }else if (rcmd == 'c') {        
                //Please insert your answer
                sat.printf("Command Get %d\r\n",rcmd);
                com.printf("HEPTA Uplink OK\r\n");
                sat.printf("===================\r\n");
                sat.printf("Accel sensing Mode\r\n");
                sat.printf("===================\r\n");
                for(int ii = 0; ii < 10; ii++) {
                    sensor.sen_acc(&ax,&ay,&az);
                    com.printf("AX = %f\r\n",ax);
                    com.printf("AY = %f\r\n",ay);
                    com.printf("AZ = %f\r\n",az);
                    wait(0.5);
                }
            }else if (rcmd == 'd') {
                sat.printf("Command Get %d\r\n",rcmd);
                com.printf("HEPTA Uplink OK\r\n");
                sat.printf("===================\r\n");
                sat.printf("Gyro sensing Mode\r\n");
                sat.printf("===================\r\n");
                for(int ii = 0; ii < 10; ii++) {
                    sensor.sen_gyro(&gx,&gy,&gz);
                    com.printf("GX = %f\r\n",gx);
                    com.printf("GY = %f\r\n",gy);
                    com.printf("GZ = %f\r\n",gz);
                    wait(0.5);
                }

            }else if (rcmd == 'e') {
                sat.printf("Command Get %d\r\n",rcmd);
                com.printf("HEPTA Uplink OK\r\n");
                sat.printf("===================\r\n");
                sat.printf("CO2 sensing Mode\r\n");
                sat.printf("===================\r\n");
                
                co2ppm = 42;
                for(int ii = 0; ii < 10; ii++) {
                    read_co2();
                    co2ppm = co2_str[2]*256 + co2_str[3];
                    com.printf("CO2 = %d [ppm]\r\n",co2ppm);
                    wait(0.5);
                }
            }
            com.initialize();
        }
    }
    sattime.stop();
    sat.printf("From Sat : End of operation\r\n");
    com.printf("From Sat : End of operation\r\n");
}

