#ifndef ENCODER_H
#define ENCODER_H

#include "mbed.h"

/****定数****/
#define PI 3.1415f
#define RADIAN 360
#define MINUTE 60
#define CALCULATE_PERIOD 0.01f

enum DATA_CATEGORY{
    COUNT,
    ROTATION,
    RPM,
    DISTANCE,
    ANGLE,
    POSITION,
};


class Encoder {
    public:
        Encoder(PinName Apulse,PinName Bpulse);
        void setup(int Ppr = 400,int Diameter = 0);
        void calculate();
        float getData(short ch);
        void reset();
    private:
        InterruptIn Apulse;
        InterruptIn Bpulse;
        Ticker RpmCalculateTimer;
    
        void Apulse_Up();
        void Apulse_Down();
        void Bpulse_Up();
        void Bpulse_Down();
        void RpmCalculate();
        
        float PPR,DIAMETER,count,rotation,rpm,distance,angle,position;
};

#endif