#include "Encoder.h"

Encoder::Encoder(PinName Apulse,PinName Bpulse) : Apulse(Apulse),Bpulse(Bpulse) {
    Encoder::Apulse.rise(this,&Encoder::Apulse_Up);
    Encoder::Apulse.fall(this,&Encoder::Apulse_Down);
    Encoder::Bpulse.rise(this,&Encoder::Bpulse_Up);
    Encoder::Bpulse.fall(this,&Encoder::Bpulse_Down);
    RpmCalculateTimer.attach(this,&Encoder::RpmCalculate,CALCULATE_PERIOD);
}

void Encoder::Apulse_Up() {
    if(Bpulse) {
        count--;
    } else {
        count++;
    } 
}

void Encoder::Apulse_Down() {
    if(Bpulse) {
        count++;
    } else {
        count--;
    }
}

void Encoder::Bpulse_Up() {
    if(Apulse) {
        count++;
    } else {
        count--;
    }
}

void Encoder::Bpulse_Down() {
    if(Apulse) {
        count--;
    } else {
        count++;
    }
}

void Encoder::RpmCalculate() {
    static float rotationBuffer = 0;
    rotation = count / PPR;
    rpm = (rotation - rotationBuffer) / CALCULATE_PERIOD * MINUTE;
    rotationBuffer = rotation;
    
    angle = rotation * RADIAN;
    position = angle - (float)((int)angle / RADIAN) * RADIAN;
}

void Encoder::setup(int Ppr,int Diameter) {
    PPR = Ppr;
    DIAMETER = Diameter;
}

void Encoder::calculate() {
    //rotation = count / PPR;
    //distance = DIAMETER * rotation * PI;
    //angle = rotation * RADIAN;
    //position = angle - (float)((int)angle / RADIAN) * RADIAN;
}
/****値返す用の関数****/
float Encoder::getData(short ch) {
    switch(ch) {
        case COUNT:
            return count;               //カウント
            break;
        case ROTATION:
            return rotation;            //回転量
            break;
        case RPM:
            return rpm;                 //rpm
            break;
        case DISTANCE:
            return distance;            //距離(mm)
            break;
        case ANGLE:
            return angle;               //角度
            break;
        case POSITION:
            return position;            //角度（0度から360度までの間の値）
            break;
        default:
            return 0;
            break;
    }
}

void Encoder::reset() {
    count = 0.0f;
}