#include "mbed_m.h"
#include "Adafruit_PWMServoDriver.h"
#include "Adafruit_MotorShield.h"
#include "mbed.h"
#include "BNO055.h"
#include "BME280.h"

//適宜定数を記述する
#define del_t 0.0005 // 制御周期 0.005 ms
#define Kp 5       //Pゲイン
#define Ki 0.000     //Iゲイン
#define Kd 0.00005  //Dゲイン

//BNO055用の定義
Serial pc(USBTX, USBRX);         //PCへのシリアル通信
DigitalOut myled(LED1);          //mbed LED1
I2C ifaceI2C(I2C_SDA, I2C_SCL);  //センサー用のI2C
BOARDC_BNO055 sensor1(&ifaceI2C);//センサーで使うI2Cの定義
//PID制御用
Ticker flipper;
Timer engi;
I2C i2c(I2C_SDA, I2C_SCL);
//モーターシールド用
Adafruit_MotorShield AFMS(&i2c); 
Adafruit_DCMotor *myMotor = AFMS.getMotor(2);

int duty_value = 0;
bool renew = false;
void det_duty(int duty);
float pitch;

void det_duty(int duty)// duty: -255~255
{
    uint16_t abs_duty;    //モータの各動作の設定
    if(duty < -255)    {
        myMotor->run(BACKWARD);
        myMotor->setSpeed(255);
    }
    else if(duty < 0)    {
        abs_duty = (uint16_t)(-1* duty);
        myMotor->run(BACKWARD);
        myMotor->setSpeed(abs_duty);
    }
    else if(duty == 0)    {
        myMotor->run(RELEASE);
    }
    else if(duty <= 255)    {
        abs_duty = (uint16_t)(duty);
        myMotor->run(FORWARD);
        myMotor->setSpeed(abs_duty);
    }
    else    {
        myMotor->run(FORWARD);
        myMotor->setSpeed(255);
    }
}
 
/// この箇所にPIDの制御を記述する．
void flip()
{
    //適宜変数を追加する
    int duty = 0;
    float p,i,d;
    float refe = 0.0;
    float posi;
    
    static float diff[2] = {0,0};
    static float inte = 0;
    
    posi = pitch;
    
    //
    //PID
    //
    diff[0] = diff[1];
    diff[1] = refe - posi;
    inte += (diff[1] + diff[0])/2.0*del_t;
    
    p = Kp*diff[1];
    i = Ki*inte;
    d = Kd*(diff[1]-diff[0])/del_t;
    duty = (int)(p+i+d);

    //デューティ比を受け渡す
    if(duty > 0 )
    duty = 30 + duty; //myMotor->setSpeed(duty_value);
    else if(duty < 0)
    duty = -25 + duty;
        
    // 最大+-7.5Vを超えないようにデューティ比を調整
    if(duty > 250 ) duty = 250;
    else if(duty < -250) duty = -250;

    duty_value = duty;
    
    myled != myled;
    renew =true;
}
 
int main()
{
    pc.printf("Hello_mbed!\n");    //確認用

    //I2Cインターフェースで２つのセンサーを使用する(200KHz)
    ifaceI2C.frequency(200000);
    sensor1.initialize(false);
    engi.start();


    //各センサーの値を格納するための変数宣言
    short dataBox[12];
    float scEUL;
    scEUL = sensor1.getEulerScale();
 
    pc.printf("Check!\n");          //確認用

    while(1)
    {
        //配列dataBoxに、9軸の値とオイラー角(pitch)を格納
        //倍率をかけてRaw値を実際の値に変換
        sensor1.get9AxisAndEUL(dataBox);
        pitch = (float)dataBox[11] * scEUL;
        float time = engi.read();


        //角度とデューティ比の表示
        pc.printf("%05.4f,%05.4d,%4.1f\n", pitch,duty_value,time);

        AFMS.begin();
        myMotor->run(FORWARD);
        myMotor->run(RELEASE);
 
        flipper.attach(&flip, del_t);
 
        if(renew)
        {
            det_duty(-1.0 * duty_value);    //打ち消す方向に変換
            renew = false;
        }
    }
}