/*************************************************** 
  This is a library for our Adafruit 16-channel PWM & Servo driver

  Pick one up today in the adafruit shop!
  ------> http://www.adafruit.com/products/815

  These displays use I2C to communicate, 2 pins are required to  
  interface. For Arduino UNOs, thats SCL -> Analog 5, SDA -> Analog 4

  Adafruit invests time and resources providing this open source code, 
  please support Adafruit and open-source hardware by purchasing 
  products from Adafruit!

  Written by Limor Fried/Ladyada for Adafruit Industries.  
  BSD license, all text above must be included in any redistribution
 ****************************************************/

#include "Adafruit_PWMServoDriver.h"
void dumy_handler(int events);
//I2C i2c(I2C_SDA, I2C_SCL);



Adafruit_PWMServoDriver::Adafruit_PWMServoDriver(I2C *i2c, uint8_t addr)
{
  _i2c = i2c;
  _i2caddr = addr;
  _dumy_callback.attach(dumy_handler);
}

void Adafruit_PWMServoDriver::begin(void) 
{
    reset();
}


void Adafruit_PWMServoDriver::reset(void) 
{
 write8(PCA9685_MODE1, 0x0);
}

void Adafruit_PWMServoDriver::setPWMFreq(float freq) 
{
  //Serial.print("Attempting to set freq ");
  //Serial.println(freq);
  freq *= 0.9;  // Correct for overshoot in the frequency setting (see issue #11).
  float prescaleval = 25000000;
  prescaleval /= 4096;
  prescaleval /= freq;
  prescaleval -= 1;
  //Serial.print("Estimated pre-scale: "); Serial.println(prescaleval);
  uint8_t prescale = (uint8_t)(floor((double)(prescaleval + 0.5)));
  //Serial.print("Final pre-scale: "); Serial.println(prescale);  
  
  uint8_t oldmode = read8(PCA9685_MODE1);
  uint8_t newmode = (oldmode&0x7F) | 0x10; // sleep
  write8(PCA9685_MODE1, newmode); // go to sleep
  write8(PCA9685_PRESCALE, prescale); // set the prescaler
  write8(PCA9685_MODE1, oldmode);
  //delay(5);
  wait_ms((float)5.0);
  write8(PCA9685_MODE1, oldmode | 0xa1);  //  This sets the MODE1 register to turn on auto increment.
                                          // This is why the beginTransmission below was not working.
  //  Serial.print("Mode now 0x"); Serial.println(read8(PCA9685_MODE1), HEX);
}

void Adafruit_PWMServoDriver::setPWM(uint8_t num, uint16_t on, uint16_t off) 
{
char buf[5],rbuf[1];
buf[0] = (char)(LED0_ON_L+4*num);
buf[1] = (char)(on & 0x00ff);
buf[2] = (char)((on>>8) & 0x00ff);
buf[3] = (char) (off & 0x00ff);
buf[4] = (char)((off>>8) & 0x00ff);
_i2c->abort_transfer();

if(_i2c->write((int)(_i2caddr<<1) , buf , 0, 0)==0){
    //wait_us(100);
    if(_i2c->write((int)(_i2caddr<<1) , buf , 5, 0)!=5) {
        _i2c->reset();
        //i2c.stop();
        //i2c.abort_transfer();
        }
}
else{_i2c->reset();}
//i2c.transfer((int)(_i2caddr<<1), buf , 5, rbuf, 0, _dumy_callback);
}

uint8_t Adafruit_PWMServoDriver::read8(uint8_t addr) 
{
char buf[2];
char ch = (char)addr;
_i2c->write((int)(_i2caddr<<1) , &ch , 1, 0);
_i2c->read((int)(_i2caddr<<1) , buf , 1 , 0);
return (uint8_t)buf[0];
}

void Adafruit_PWMServoDriver::write8(uint8_t addr, uint8_t d) 
{
char buf[2],rbuf[1];
buf[0] = (char)addr;
buf[1] = (char)d;
_i2c->abort_transfer();
if(_i2c->write((int)(_i2caddr<<1) , buf , 0, 0)==0){
    //wait_us(100);
    if(_i2c->write((int)(_i2caddr<<1) , buf , 2, 0)!=2){ 
    _i2c->reset();
    //i2c.stop();
    //i2c.abort_transfer();
    }
//i2c.transfer((int)(_i2caddr<<1), buf , 2, rbuf, 0, _dumy_callback);
}
else{ _i2c->reset();}
}

void Adafruit_PWMServoDriver::dumy_read(void)
{
 read8(0);
 return;    
}

void dumy_handler(int events)
{
}

